/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.encoding;

import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.encoding.Encoding;
import de.intarsys.pdf.encoding.GlyphNameMap;
import de.intarsys.pdf.font.CMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CMapEncoding
extends Encoding {
    private final CMap cmap;

    public CMapEncoding(CMap cMap) {
        this.cmap = cMap;
    }

    public COSObject cosGetObject() {
        return null;
    }

    public int getDecoded(int n) {
        return this.cmap.getDecoded(n);
    }

    public int getEncoded(int n) {
        return this.cmap.getEncoded(n);
    }

    public int getEncoded(String string) {
        return this.getEncoded(GlyphNameMap.Standard.getUnicode(string));
    }

    public String getGlyphName(int n) {
        return GlyphNameMap.Standard.getGlyphName(this.getDecoded(n));
    }

    public String getName() {
        return "CMapEncoding";
    }

    public int getNextDecoded(InputStream inputStream) throws IOException {
        return this.cmap.getNextDecoded(inputStream);
    }

    public int getNextEncoded(InputStream inputStream) throws IOException {
        return this.cmap.getNextEncoded(inputStream);
    }

    public int getValidEncoded(int n) {
        int n2 = this.getEncoded(n);
        if (n2 == -1) {
            return 32;
        }
        return n2;
    }

    public int getValidEncoded(String string) {
        int n = this.getEncoded(string);
        if (n == -1) {
            return 32;
        }
        return n;
    }

    public void putNextDecoded(OutputStream outputStream, int n) throws IOException {
        this.cmap.putNextDecoded(outputStream, n);
    }

    public void putNextEncoded(OutputStream outputStream, int n) throws IOException {
        this.cmap.putNextEncoded(outputStream, n);
    }
}

