/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.encoding;

import de.intarsys.pdf.encoding.Encoding;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class MappedReader
extends Reader {
    private Encoding encoding;
    private InputStream inStream;

    public MappedReader(InputStream inputStream, Encoding encoding) {
        super(inputStream);
        this.setInStream(inputStream);
        this.setEncoding(encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.inStream == null) {
                return;
            }
            this.inStream.close();
            this.inStream = null;
        }
    }

    protected void ensureOpen() throws IOException {
        if (this.inStream == null) {
            throw new IOException("Stream closed");
        }
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            int n3 = n + n2;
            int n4 = 0;
            int n5 = n;
            while (true) {
                if (n5 >= n3) {
                    return n2;
                }
                n4 = this.encoding.getNextDecoded(this.inStream);
                if (n4 == -1) {
                    if (n5 == n) {
                        return -1;
                    }
                    return n5 - n;
                }
                cArray[n5] = (char)n4;
                ++n5;
            }
        }
    }

    private void setEncoding(Encoding encoding) {
        this.encoding = encoding;
    }

    protected void setInStream(InputStream inputStream) {
        this.inStream = inputStream;
    }
}

