/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.filter;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ASCII85OutputStream
extends FilterOutputStream {
    private static final long HIGH_VALUE = 0xFFFFFFFFL;
    private static final long CONST_85 = 85L;
    private byte[] indata = new byte[4];
    private byte[] outdata = new byte[5];
    private boolean flushed = true;
    private int count = 0;
    private int lineBreak = 72;
    private int maxline = 72;

    public ASCII85OutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void setLineLength(int n) {
        if (this.lineBreak > n) {
            this.lineBreak = n;
        }
        this.maxline = n;
    }

    public int getLineLength() {
        return this.maxline;
    }

    public final void flush() throws IOException {
        if (this.flushed) {
            return;
        }
        if (this.count > 0) {
            int n = this.count;
            while (n < 4) {
                this.indata[n] = 0;
                ++n;
            }
            this.transform();
            if (this.outdata[0] == 122) {
                n = 0;
                while (n < 5) {
                    this.outdata[n] = 33;
                    ++n;
                }
            }
            n = 0;
            while (n < this.count + 1) {
                this.out.write(this.outdata[n]);
                if (--this.lineBreak == 0) {
                    this.out.write(10);
                    this.lineBreak = this.maxline;
                }
                ++n;
            }
        }
        if (--this.lineBreak == 0) {
            this.out.write(10);
        }
        this.count = 0;
        this.lineBreak = this.maxline;
        this.flushed = true;
        super.flush();
    }

    public void write(int n) throws IOException {
        this.flushed = false;
        this.indata[this.count++] = (byte)n;
        if (this.count < 4) {
            return;
        }
        this.transform();
        int n2 = 0;
        while (n2 < 5) {
            if (this.outdata[n2] == 0) break;
            this.out.write(this.outdata[n2]);
            if (--this.lineBreak == 0) {
                this.out.write(10);
                this.lineBreak = this.maxline;
            }
            ++n2;
        }
        this.count = 0;
    }

    public final void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            if (this.count < 3) {
                this.indata[this.count++] = byArray[n + n3];
            } else {
                this.write(byArray[n + n3]);
            }
            ++n3;
        }
    }

    public void close() throws IOException {
        try {
            this.flush();
            this.out.write(126);
            this.out.write(62);
            this.out.write(10);
            super.close();
        }
        finally {
            this.indata = null;
            this.outdata = null;
        }
    }

    protected void transform() {
        long l = (long)((this.indata[0] << 8 | this.indata[1] & 0xFF) << 16 | (this.indata[2] & 0xFF) << 8 | this.indata[3] & 0xFF) & 0xFFFFFFFFL;
        if (l == 0L) {
            this.outdata[0] = 122;
            this.outdata[1] = 0;
            return;
        }
        long l2 = l / 52200625L;
        this.outdata[0] = (byte)(l2 + 33L);
        l -= l2 * 85L * 85L * 85L * 85L;
        l2 = l / 614125L;
        this.outdata[1] = (byte)(l2 + 33L);
        l -= l2 * 85L * 85L * 85L;
        l2 = l / 7225L;
        this.outdata[2] = (byte)(l2 + 33L);
        l -= l2 * 85L * 85L;
        l2 = l / 85L;
        this.outdata[3] = (byte)(l2 + 33L);
        this.outdata[4] = (byte)(l % 85L + 33L);
    }
}

