/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.filter;

import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.filter.CCITTFaxDecoder;
import de.intarsys.pdf.filter.Filter;

public class CCITTFaxFilter
extends Filter {
    public static final COSName DK_BlackIs1 = COSName.constant("BlackIs1");
    public static final COSName DK_Columns = COSName.constant("Columns");
    public static final COSName DK_DamagedRowsBeforeError = COSName.constant("DamagedRowsBeforeError");
    public static final COSName DK_EncodedByteAlign = COSName.constant("EncodedByteAlign");
    public static final COSName DK_EndOfBlock = COSName.constant("EndOfBlock");
    public static final COSName DK_EndOfLine = COSName.constant("EndOfLine");
    public static final COSName DK_H = COSName.constant("H");
    public static final COSName DK_Height = COSName.constant("Height");
    public static final COSName DK_K = COSName.constant("K");
    public static final COSName DK_Rows = COSName.constant("Rows");
    public static final COSName DK_W = COSName.constant("W");
    public static final COSName DK_Width = COSName.constant("Width");

    public CCITTFaxFilter(COSDictionary cOSDictionary) {
        super(cOSDictionary);
    }

    protected byte[] decode(byte[] byArray) {
        int n = 1728;
        COSInteger cOSInteger = this.getStream().getDict().get(DK_Width).asInteger();
        if (cOSInteger == null) {
            cOSInteger = this.getStream().getDict().get(DK_W).asInteger();
        }
        if (cOSInteger != null) {
            n = cOSInteger.intValue();
        }
        int n2 = 0;
        COSInteger cOSInteger2 = this.getStream().getDict().get(DK_Height).asInteger();
        if (cOSInteger2 == null) {
            cOSInteger2 = this.getStream().getDict().get(DK_H).asInteger();
        }
        if (cOSInteger2 != null) {
            n2 = cOSInteger2.intValue();
        }
        int n3 = this.getOption(DK_Columns).getValueInteger(n);
        int n4 = this.getOption(DK_Rows).getValueInteger(n2);
        int n5 = this.getOption(DK_K).getValueInteger(0);
        int n6 = n4 * (n3 + 7 >> 3);
        byte[] byArray2 = new byte[n6];
        boolean bl = this.getOption(DK_EncodedByteAlign).getValueBoolean(false);
        CCITTFaxDecoder cCITTFaxDecoder = new CCITTFaxDecoder(1, n3, n4);
        cCITTFaxDecoder.setAlign(bl);
        if (n5 == 0) {
            cCITTFaxDecoder.decodeT41D(byArray2, byArray, 0, n4);
        } else if (n5 > 0) {
            cCITTFaxDecoder.decodeT42D(byArray2, byArray, 0, n4);
        } else if (n5 < 0) {
            cCITTFaxDecoder.decodeT6(byArray2, byArray, 0, n4);
        }
        if (!this.getOption(DK_BlackIs1).getValueBoolean(false)) {
            int n7 = 0;
            while (n7 < byArray2.length) {
                byArray2[n7] = ~byArray2[n7];
                ++n7;
            }
        }
        return byArray2;
    }

    protected byte[] encode(byte[] byArray) {
        return null;
    }
}

