/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.filter;

import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.filter.IPrediction;
import de.intarsys.pdf.filter.IPredictionFactory;
import de.intarsys.pdf.filter.NoPrediction;
import de.intarsys.pdf.filter.PNGOptimumPrediction;
import de.intarsys.pdf.filter.Prediction;
import de.intarsys.pdf.filter.TIFFPrediction;
import java.io.IOException;

public class StandardPredictionFactory
implements IPredictionFactory {
    public IPrediction createPrediction(COSDictionary cOSDictionary) throws IOException {
        COSInteger cOSInteger = cOSDictionary.get(Prediction.DK_Predictor).asInteger();
        int n = cOSInteger == null ? 1 : cOSInteger.intValue();
        if (n == 1) {
            return new NoPrediction(cOSDictionary);
        }
        if (n == 2) {
            return new TIFFPrediction(cOSDictionary);
        }
        if (n >= 10) {
            return new PNGOptimumPrediction(cOSDictionary);
        }
        throw new IOException("unknown predictor: " + n);
    }
}

