/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.encoding.Encoding;
import de.intarsys.pdf.encoding.MappedEncoding;
import de.intarsys.pdf.font.PDFont;
import java.util.Iterator;

public class DifferenceEncoding
extends Encoding {
    public static final COSName DK_Differences = COSName.constant("Differences");
    public static final COSName DK_BaseEncoding = COSName.constant("BaseEncoding");
    private final COSDictionary dict;
    private Encoding baseEncoding;
    private MappedEncoding differenceEncoding;

    public static Encoding create(COSDictionary cOSDictionary, PDFont pDFont) {
        DifferenceEncoding differenceEncoding = new DifferenceEncoding(cOSDictionary);
        COSObject cOSObject = cOSDictionary.get(DK_BaseEncoding);
        Encoding encoding = null;
        if (cOSObject.isNull()) {
            encoding = pDFont.createDefaultEncoding();
        }
        if (cOSObject instanceof COSName) {
            encoding = Encoding.createNamed((COSName)cOSObject);
        }
        differenceEncoding.setBaseEncoding(encoding);
        MappedEncoding mappedEncoding = new MappedEncoding();
        differenceEncoding.setDifferenceEncoding(mappedEncoding);
        COSArray cOSArray = cOSDictionary.get(DK_Differences).asArray();
        if (cOSArray != null) {
            int n = -1;
            Iterator iterator = cOSArray.iterator();
            while (iterator.hasNext()) {
                COSObject cOSObject2 = (COSObject)iterator.next();
                if (cOSObject2 instanceof COSNumber) {
                    n = ((COSNumber)cOSObject2).intValue();
                }
                if (!(cOSObject2 instanceof COSName) || n <= -1) continue;
                String string = ((COSName)cOSObject2).stringValue();
                mappedEncoding.addEncoding(n, string);
                ++n;
            }
        }
        return differenceEncoding;
    }

    protected DifferenceEncoding(COSDictionary cOSDictionary) {
        this.dict = cOSDictionary;
    }

    protected COSDictionary cosGetDict() {
        return this.dict;
    }

    public COSObject cosGetObject() {
        return this.cosGetDict();
    }

    protected Encoding getBaseEncoding() {
        return this.baseEncoding;
    }

    public int getDecoded(int n) {
        int n2 = this.getDifferenceEncoding().getDecoded(n);
        if (n2 == -1) {
            n2 = this.getBaseEncoding().getDecoded(n);
        }
        return n2;
    }

    public int getDifferenceDecoded(int n) {
        int n2 = this.getDifferenceEncoding().getDecoded(n);
        if (n2 == -1) {
            return n;
        }
        return n2;
    }

    protected MappedEncoding getDifferenceEncoding() {
        return this.differenceEncoding;
    }

    public String getDifferenceGlyphName(int n) {
        String string = this.getDifferenceEncoding().getGlyphName(n);
        if (string == null || string.equals(".notdef")) {
            return null;
        }
        return string;
    }

    public int getEncoded(int n) {
        int n2 = this.getDifferenceEncoding().getEncoded(n);
        if (n2 == -1) {
            n2 = this.getBaseEncoding().getEncoded(n);
        }
        return n2;
    }

    public int getEncoded(String string) {
        int n = this.getDifferenceEncoding().getEncoded(string);
        if (n == -1) {
            n = this.getBaseEncoding().getEncoded(string);
        }
        return n;
    }

    public String getGlyphName(int n) {
        String string = this.getDifferenceEncoding().getGlyphName(n);
        if (string == null || string.equals(".notdef")) {
            string = this.getBaseEncoding().getGlyphName(n);
        }
        return string;
    }

    public String getName() {
        return "DifferenceEncoding";
    }

    public int getValidEncoded(int n) {
        int n2 = this.getDifferenceEncoding().getEncoded(n);
        if (n2 == -1) {
            n2 = this.getBaseEncoding().getValidEncoded(n);
        }
        return n2;
    }

    public int getValidEncoded(String string) {
        int n = this.getDifferenceEncoding().getEncoded(string);
        if (n == -1) {
            n = this.getBaseEncoding().getValidEncoded(string);
        }
        return n;
    }

    public boolean isFontSpecificEncoding() {
        return this.getBaseEncoding().isFontSpecificEncoding();
    }

    private void setBaseEncoding(Encoding encoding) {
        this.baseEncoding = encoding;
    }

    protected void setDifferenceEncoding(MappedEncoding mappedEncoding) {
        this.differenceEncoding = mappedEncoding;
    }
}

