/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.pdf.font.PDFontDescriptor;
import de.intarsys.pdf.pd.AbstractBitFlags;

public class FontDescriptorFlags
extends AbstractBitFlags {
    public static final int Bit_FixedPitch = 1;
    public static final int Bit_Serif = 2;
    public static final int Bit_Symbolic = 4;
    public static final int Bit_Script = 8;
    public static final int Bit_Nonsymbolic = 32;
    public static final int Bit_Italic = 64;
    public static final int Bit_AllCap = 65536;
    public static final int Bit_SmallCap = 131072;
    public static final int Bit_ForceBold = 262144;
    private PDFontDescriptor fontDescriptor;

    public FontDescriptorFlags(int n) {
        super(n);
    }

    public FontDescriptorFlags(PDFontDescriptor pDFontDescriptor) {
        super(pDFontDescriptor, null);
        this.fontDescriptor = pDFontDescriptor;
    }

    protected PDFontDescriptor getFontDescriptor() {
        return this.fontDescriptor;
    }

    protected int getValueInObject() {
        return this.getFontDescriptor().getFlagsValue();
    }

    public boolean isAllCap() {
        return this.isSetAnd(65536);
    }

    public boolean isFixedPitch() {
        return this.isSetAnd(1);
    }

    public boolean isForceBold() {
        return this.isSetAnd(262144);
    }

    public boolean isItalic() {
        return this.isSetAnd(64);
    }

    public boolean isNonsymbolic() {
        return this.isSetAnd(32);
    }

    public boolean isScript() {
        return this.isSetAnd(8);
    }

    public boolean isSerif() {
        return this.isSetAnd(2);
    }

    public boolean isSmallCap() {
        return this.isSetAnd(131072);
    }

    public boolean isSymbolic() {
        return this.isSetAnd(4);
    }

    public void setAllCap(boolean bl) {
        this.set(65536, bl);
    }

    public void setFixedPitch(boolean bl) {
        this.set(1, bl);
    }

    public void setForceBold(boolean bl) {
        this.set(262144, bl);
    }

    public void setItalic(boolean bl) {
        this.set(64, bl);
    }

    public void setNonsymbolic(boolean bl) {
        this.set(32, bl);
        this.set(4, !bl);
    }

    public void setScript(boolean bl) {
        this.set(8, bl);
    }

    public void setSerif(boolean bl) {
        this.set(2, bl);
    }

    public void setSmallCap(boolean bl) {
        this.set(131072, bl);
    }

    public void setSymbolic(boolean bl) {
        this.set(4, bl);
        this.set(32, !bl);
    }

    protected void setValueInObject(int n) {
        this.getFontDescriptor().setFlagsValue(n);
    }
}

