/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.cwt.font.afm.AFM;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.font.PDFontDescriptor;
import de.intarsys.pdf.font.PDFontType1;
import java.util.StringTokenizer;

public class PDFontDescriptorAFM
extends PDFontDescriptor {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private AFM afm;
    private int leading;
    private CDSRectangle bb;

    protected PDFontDescriptorAFM(AFM aFM) {
        super(null);
        this.afm = aFM;
    }

    public AFM getAfm() {
        return this.afm;
    }

    public float getAscent() {
        String string = this.getAfm().getAttribute("Ascender");
        if (string == null) {
            return 0.0f;
        }
        return Float.parseFloat(string);
    }

    public float getAvgWidth() {
        return 0.0f;
    }

    public float getCapHeight() {
        String string = this.getAfm().getAttribute("CapHeight");
        if (string == null) {
            return 0.0f;
        }
        return Float.parseFloat(string);
    }

    public String getCharSet() {
        return null;
    }

    public float getDescent() {
        String string = this.getAfm().getAttribute("Descender");
        if (string == null) {
            return 0.0f;
        }
        return Float.parseFloat(string);
    }

    public int getFlagsValue() {
        return 0;
    }

    public CDSRectangle getFontBB() {
        if (this.bb == null) {
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            String string = this.getAfm().getAttribute("FontBBox");
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                if (stringTokenizer.hasMoreTokens()) {
                    f = Float.parseFloat(stringTokenizer.nextToken());
                }
                if (stringTokenizer.hasMoreTokens()) {
                    f2 = Float.parseFloat(stringTokenizer.nextToken());
                }
                if (stringTokenizer.hasMoreTokens()) {
                    f3 = Float.parseFloat(stringTokenizer.nextToken());
                }
                if (stringTokenizer.hasMoreTokens()) {
                    f4 = Float.parseFloat(stringTokenizer.nextToken());
                }
            }
            this.bb = new CDSRectangle(f, f2, f3, f4);
        }
        return this.bb;
    }

    public String getFontFamily() {
        return null;
    }

    public String getFontName() {
        if (this.getAfm() == null) {
            return "";
        }
        String string = this.getAfm().getAttribute("FontName");
        if (string == null) {
            return "";
        }
        return string.trim();
    }

    public String getFontStretch() {
        return null;
    }

    public int getFontWeight() {
        return 0;
    }

    public float getItalicAngle() {
        String string = this.getAfm().getAttribute("ItalicAngle");
        if (string == null) {
            return 0.0f;
        }
        return Float.parseFloat(string);
    }

    public int getLeading() {
        if (this.leading == 0) {
            CDSRectangle cDSRectangle = this.getFontBB();
            this.leading = (int)(cDSRectangle.getUpperRightY() - cDSRectangle.getLowerLeftY());
        }
        return this.leading;
    }

    public int getMaxWidth() {
        return 0;
    }

    public int getMissingWidth() {
        return 0;
    }

    public int getStemH() {
        String string = this.getAfm().getAttribute("StdHW");
        if (string == null) {
            return 0;
        }
        return (int)Float.parseFloat(string);
    }

    public int getStemV() {
        String string = this.getAfm().getAttribute("StdVW");
        if (string == null) {
            return 0;
        }
        return (int)Float.parseFloat(string);
    }

    public float getXHeight() {
        String string = this.getAfm().getAttribute("XHeight");
        if (string == null) {
            return 0.0f;
        }
        return Float.parseFloat(string);
    }

    public boolean isBuiltin() {
        return true;
    }

    public boolean isNonsymbolic() {
        return !this.isSymbolic();
    }

    public boolean isSymbolic() {
        String string = this.getFontName();
        return PDFontType1.FONT_ZapfDingbats.equals(string) || PDFontType1.FONT_Symbol.equals(string);
    }

    public void setCharSet(String string) {
    }

    public void setFlagsValue(int n) {
    }

    public void setFontStretch(String string) {
    }

    public void setFontWeight(int n) {
    }

    public static class MetaClass
    extends PDFontDescriptor.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }

        protected COSBasedObject doCreateCOSBasedObject(COSObject cOSObject) {
            throw new IllegalStateException("can not instantiate PDFontDescriptorAFM as COSBasedObject");
        }
    }
}

