/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontDescriptor;
import de.intarsys.pdf.font.PDFontDescriptorType3;
import de.intarsys.pdf.font.PDFontStyle;
import de.intarsys.pdf.font.PDSingleByteFont;
import de.intarsys.pdf.pd.IResourcesProvider;
import de.intarsys.pdf.pd.PDResources;

public class PDFontType3
extends PDSingleByteFont
implements IResourcesProvider {
    public static final COSName DK_FontBBox = COSName.constant("FontBBox");
    public static final COSName DK_FontMatrix = COSName.constant("FontMatrix");
    public static final COSName DK_CharProcs = COSName.constant("CharProcs");
    public static final COSName DK_Resources = COSName.constant("Resources");
    public static final COSName DK_ToUnicode = COSName.constant("ToUnicode");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());

    public PDFontType3(COSObject cOSObject) {
        super(cOSObject);
    }

    public COSDictionary cosGetCharProcs() {
        return this.cosGetField(DK_CharProcs).asDictionary();
    }

    protected COSName cosGetExpectedSubtype() {
        return CN_Subtype_Type3;
    }

    public COSDictionary cosSetCharProcs(COSDictionary cOSDictionary) {
        return this.cosSetField(DK_CharProcs, cOSDictionary).asDictionary();
    }

    protected PDFontDescriptor createBuiltinFontDescriptor() {
        return new PDFontDescriptorType3(this);
    }

    public CDSRectangle getFontBB() {
        return CDSRectangle.createFromCOS(this.cosGetField(DK_FontBBox).asArray());
    }

    public String getFontFamilyName() {
        return "Helvetica";
    }

    public CDSMatrix getFontMatrix() {
        return CDSMatrix.createFromCOS(this.cosGetField(DK_FontMatrix).asArray());
    }

    public String getFontName() {
        return "Helvetica";
    }

    public PDFontStyle getFontStyle() {
        return PDFontStyle.REGULAR;
    }

    public String getFontType() {
        return "Type3";
    }

    public int getGlyphWidthEncoded(int n) {
        int n2 = super.getGlyphWidthEncoded(n);
        float[] fArray = new float[]{n2, 0.0f};
        fArray = this.getFontMatrix().transform(fArray);
        return (int)(fArray[0] * 1000.0f);
    }

    public PDResources getResources() {
        COSDictionary cOSDictionary = this.cosGetField(DK_Resources).asDictionary();
        return (PDResources)PDResources.META.createFromCos(cOSDictionary);
    }

    public boolean isEmbedded() {
        return true;
    }

    public boolean isSubset() {
        return false;
    }

    public void setFontBB(CDSRectangle cDSRectangle) {
        this.setFieldObject(DK_FontBBox, cDSRectangle);
    }

    public void setFontMatrix(CDSMatrix cDSMatrix) {
        this.setFieldObject(DK_FontMatrix, cDSMatrix);
    }

    public void setResources(PDResources pDResources) {
        this.cosSetField(DK_Resources, pDResources.cosGetDict());
    }

    public String toString() {
        return this.cosGetSubtype() + "-Font ";
    }

    public static class MetaClass
    extends PDFont.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }

        protected COSBasedObject doCreateCOSBasedObject(COSObject cOSObject) {
            return new PDFontType3(cOSObject);
        }
    }
}

