/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.pdf.font.CMap;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;

public class PDGlyphs
implements IAttributeSupport {
    private final PDFont font;
    private final int codepoint;
    private final AttributeMap attributes = new AttributeMap();
    private float width;
    private Boolean whitespace;

    public PDGlyphs(PDFont pDFont, int n) {
        this.font = pDFont;
        this.codepoint = n;
        this.width = pDFont.getGlyphWidthEncoded(n);
    }

    public double getAscent() {
        return this.font.getFontDescriptor().getAscent();
    }

    public Object getAttribute(Object object) {
        return this.attributes.getAttribute(object);
    }

    public int getCodepoint() {
        return this.codepoint;
    }

    public double getDescent() {
        return this.font.getFontDescriptor().getDescent();
    }

    public PDFont getFont() {
        return this.font;
    }

    public int getUnicode() {
        CMap cMap = this.font.getToUnicode();
        if (cMap == null) {
            return this.font.getEncoding().getDecoded(this.codepoint);
        }
        int n = cMap.getDecoded(this.codepoint);
        return n;
    }

    public float getWidth() {
        return this.width;
    }

    public boolean isWhitespace() {
        if (this.whitespace != null) {
            return this.whitespace;
        }
        int n = this.getUnicode();
        this.whitespace = n == 0 || Character.isWhitespace(n);
        return this.whitespace;
    }

    public Object removeAttribute(Object object) {
        return this.attributes.removeAttribute(object);
    }

    public void reset() {
        this.width = this.font.getGlyphWidthEncoded(this.codepoint);
    }

    public Object setAttribute(Object object, Object object2) {
        return this.attributes.setAttribute(object, object2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("glyph ");
        stringBuilder.append((char)this.getUnicode());
        stringBuilder.append(", cp ");
        stringBuilder.append(this.codepoint);
        stringBuilder.append(", uc ");
        stringBuilder.append(this.getUnicode());
        return stringBuilder.toString();
    }
}

