/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAppearance;
import de.intarsys.pdf.pd.PDAppearanceCharacteristics;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDMarkupAnnotation;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDPopupAnnotation;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import java.util.List;

public class PDAnnotationTools {
    public static final String CAPTION_CHECK = "4";
    public static final String CAPTION_CIRCLE = "l";
    public static final String CAPTION_CROSS = "8";
    public static final String CAPTION_DIAMOND = "u";
    public static final String CAPTION_SQUARE = "n";
    public static final String CAPTION_STAR = "H";

    public static PDAppearance getAppearance(PDAnnotation pDAnnotation) {
        PDAppearance pDAppearance = pDAnnotation.getAppearance();
        if (pDAppearance == null) {
            pDAppearance = (PDAppearance)PDAppearance.META.createNew();
        }
        return pDAppearance;
    }

    public static float[] getBorderColor(PDWidgetAnnotation pDWidgetAnnotation) {
        PDAppearanceCharacteristics pDAppearanceCharacteristics = pDWidgetAnnotation.getAppearanceCharacteristics();
        if (pDAppearanceCharacteristics == null) {
            return null;
        }
        return pDAppearanceCharacteristics.getBorderColor();
    }

    public static float[] getBorderColorNegative(PDWidgetAnnotation pDWidgetAnnotation) {
        float[] fArray = PDAnnotationTools.getBorderColor(pDWidgetAnnotation);
        if (fArray == null) {
            return null;
        }
        float[] fArray2 = new float[fArray.length];
        int n = 0;
        while (n < fArray.length) {
            fArray2[n] = Math.max(Math.min(fArray2[n] + 0.25f, 1.0f), 0.0f);
            ++n;
        }
        return fArray2;
    }

    public static float[] getFillColor(PDWidgetAnnotation pDWidgetAnnotation) {
        PDAppearanceCharacteristics pDAppearanceCharacteristics = pDWidgetAnnotation.getAppearanceCharacteristics();
        if (pDAppearanceCharacteristics == null) {
            return null;
        }
        return pDAppearanceCharacteristics.getBackgroundColor();
    }

    public static float[] getFillColorNegative(PDWidgetAnnotation pDWidgetAnnotation) {
        float[] fArray = PDAnnotationTools.getFillColor(pDWidgetAnnotation);
        if (fArray == null) {
            return null;
        }
        float[] fArray2 = new float[fArray.length];
        int n = 0;
        while (n < fArray.length) {
            fArray2[n] = Math.max(Math.min(fArray[n] - 0.25f, 1.0f), 0.0f);
            ++n;
        }
        return fArray2;
    }

    public static PDAnnotation getNextAnnotation(PDAnnotation pDAnnotation) {
        PDPage pDPage = PDAnnotationTools.getPage(pDAnnotation);
        if (pDPage == null) {
            return null;
        }
        return pDPage.getNextAnnotation(pDAnnotation);
    }

    public static PDAnnotation getNextAnnotationAllPages(PDAnnotation pDAnnotation) {
        PDPage pDPage = PDAnnotationTools.getPage(pDAnnotation);
        if (pDPage == null) {
            return null;
        }
        PDAnnotation pDAnnotation2 = PDAnnotationTools.getNextAnnotation(pDAnnotation);
        while (pDAnnotation2 == null) {
            if ((pDPage = pDPage.getNextPage()) == null) {
                return null;
            }
            pDAnnotation2 = pDPage.getFirstAnnotation();
        }
        return pDAnnotation2;
    }

    public static PDPage getPage(PDAnnotation pDAnnotation) {
        PDPage pDPage = pDAnnotation.getPage();
        if (pDPage != null) {
            return pDPage;
        }
        PDDocument pDDocument = pDAnnotation.getDoc();
        if (pDDocument == null) {
            return null;
        }
        pDPage = pDDocument.getPageTree().getFirstPage();
        while (pDPage != null) {
            List list = pDPage.getAnnotations();
            if (list != null) {
                for (PDAnnotation pDAnnotation2 : list) {
                    if (pDAnnotation2.cosGetObject() != pDAnnotation.cosGetObject()) continue;
                    return pDPage;
                }
            }
            pDPage = pDPage.getNextPage();
        }
        return null;
    }

    public static PDAnnotation getPreviousAnnotation(PDAnnotation pDAnnotation) {
        PDPage pDPage = PDAnnotationTools.getPage(pDAnnotation);
        if (pDPage == null) {
            return null;
        }
        return pDPage.getPreviousAnnotation(pDAnnotation);
    }

    public static PDAnnotation getPreviousAnnotationAllPages(PDAnnotation pDAnnotation) {
        PDPage pDPage = PDAnnotationTools.getPage(pDAnnotation);
        if (pDPage == null) {
            return null;
        }
        PDAnnotation pDAnnotation2 = PDAnnotationTools.getPreviousAnnotation(pDAnnotation);
        while (pDAnnotation2 == null) {
            if ((pDPage = pDPage.getPreviousPage()) == null) {
                return null;
            }
            pDAnnotation2 = pDPage.getLastAnnotation();
        }
        return pDAnnotation2;
    }

    public static COSName getStateChecked(PDWidgetAnnotation pDWidgetAnnotation) {
        for (COSName cOSName : pDWidgetAnnotation.getAppearanceStates()) {
            if (!PDAnnotationTools.isStateChecked(cOSName)) continue;
            return cOSName;
        }
        return null;
    }

    public static boolean isAnnotationSpec14(COSDictionary cOSDictionary) {
        COSName cOSName = cOSDictionary.get(PDObject.DK_Subtype).asName();
        if (cOSName == null) {
            return false;
        }
        if (cOSName.equals(PDWidgetAnnotation.CN_Subtype_Widget)) {
            return true;
        }
        if (cOSName.equals(PDMarkupAnnotation.CN_Subtype_Ink)) {
            return true;
        }
        if (cOSName.equals(PDMarkupAnnotation.CN_Subtype_Square)) {
            return true;
        }
        if (cOSName.equals(PDMarkupAnnotation.CN_Subtype_Circle)) {
            return true;
        }
        if (cOSName.equals(PDMarkupAnnotation.CN_Subtype_Line)) {
            return true;
        }
        if (cOSName.equals(PDMarkupAnnotation.CN_Subtype_Polygon)) {
            return true;
        }
        if (cOSName.equals(PDMarkupAnnotation.CN_Subtype_PolyLine)) {
            return true;
        }
        if (cOSName.equals(PDPopupAnnotation.CN_Subtype_Popup)) {
            return true;
        }
        if (cOSName.equals(COSName.constant("Link"))) {
            return true;
        }
        if (cOSName.equals(COSName.constant("FreeText"))) {
            return true;
        }
        if (cOSName.equals(COSName.constant("Highlight"))) {
            return true;
        }
        if (cOSName.equals(COSName.constant("Underline"))) {
            return true;
        }
        if (cOSName.equals(COSName.constant("Squiggly"))) {
            return true;
        }
        if (cOSName.equals(COSName.constant("StrikeOut"))) {
            return true;
        }
        if (cOSName.equals(COSName.constant("Stamp"))) {
            return true;
        }
        if (cOSName.equals(COSName.constant("FileAttachment"))) {
            return true;
        }
        if (cOSName.equals(COSName.constant("Sound"))) {
            return true;
        }
        if (cOSName.equals(COSName.constant("Movie"))) {
            return true;
        }
        if (cOSName.equals(COSName.constant("PrinterMark"))) {
            return true;
        }
        return cOSName.equals(COSName.constant("TrapNet"));
    }

    public static boolean isStateChecked(COSName cOSName) {
        return !PDWidgetAnnotation.CN_State_Off.equals(cOSName);
    }

    public static void transform(CDSRectangle cDSRectangle, CDSMatrix cDSMatrix, int n) {
        if (n == 90) {
            cDSMatrix.setTransformation(CDSMatrix.MATRIX_90);
        } else if (n == 180) {
            cDSMatrix.setTransformation(CDSMatrix.MATRIX_180);
        } else if (n == 270) {
            cDSMatrix.setTransformation(CDSMatrix.MATRIX_270);
        }
        float[] fArray = new float[]{cDSRectangle.getWidth(), cDSRectangle.getHeight()};
        float[] fArray2 = cDSMatrix.transform(fArray);
        if (n == 90) {
            cDSMatrix.setE(cDSRectangle.getWidth());
        } else if (n == 180) {
            cDSMatrix.setE(cDSRectangle.getWidth());
            cDSMatrix.setF(cDSRectangle.getHeight());
        } else if (n == 270) {
            cDSMatrix.setF(cDSRectangle.getHeight());
        }
        cDSRectangle.setCorners(0.0f, 0.0f, fArray2[0], fArray2[1]);
        cDSRectangle.normalize();
    }

    private PDAnnotationTools() {
    }
}

