/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDPageNode;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PDPageTree
extends PDPageNode {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName DK_Kids = COSName.constant("Kids");
    public static final COSName DK_Count = COSName.constant("Count");
    private static final int MAX_KIDS = 1000;
    private SoftReference<List> cachedKids;

    protected PDPageTree(COSObject cOSObject) {
        super(cOSObject);
    }

    public void addNode(int n, PDPageNode pDPageNode) {
        COSArray cOSArray = this.cosGetField(DK_Kids).asArray();
        if (cOSArray == null) {
            cOSArray = COSArray.create();
            this.cosSetField(DK_Kids, cOSArray);
        }
        if ((n = Math.min(n, cOSArray.size())) < 0) {
            n = cOSArray.size();
        }
        pDPageNode.setParent(this);
        cOSArray.add(n, pDPageNode.cosGetDict());
        this.incrementCount(pDPageNode.getCount());
    }

    public void addNode(PDPageNode pDPageNode) {
        this.addNodeAfter(pDPageNode, null);
    }

    public void addNodeAfter(PDPageNode pDPageNode, PDPageNode pDPageNode2) {
        int n = -1;
        COSArray cOSArray = this.cosGetField(DK_Kids).asArray();
        if (cOSArray != null && pDPageNode2 != null) {
            n = cOSArray.indexOf(pDPageNode2.cosGetDict());
        }
        int n2 = -1;
        if (n > -1) {
            n2 = n + 1;
        }
        this.addNode(n2, pDPageNode);
    }

    protected void collectAnnotations(List list) {
        for (PDPageNode pDPageNode : this.getKids()) {
            pDPageNode.collectAnnotations(list);
        }
    }

    protected COSName cosGetExpectedType() {
        return CN_Type_Pages;
    }

    protected COSObject cosSetKids(COSArray cOSArray) {
        this.setCount(cOSArray.size());
        return this.cosSetField(DK_Kids, cOSArray);
    }

    protected void exchangeNode(PDPageNode pDPageNode, PDPageNode pDPageNode2) {
        COSArray cOSArray = this.cosGetField(DK_Kids).asArray();
        if (cOSArray == null) {
            return;
        }
        int n = cOSArray.indexOf(pDPageNode.cosGetDict());
        if (n >= 0) {
            pDPageNode.setParent(null);
            pDPageNode2.setParent(this);
            cOSArray.set(n, pDPageNode2.cosGetDict());
        }
    }

    public int getCount() {
        return this.getFieldInt(DK_Count, 0);
    }

    public PDPageNode getFirstNode() {
        if (this.getKids().isEmpty()) {
            return null;
        }
        return (PDPageNode)this.getKids().get(0);
    }

    public PDPage getFirstPage() {
        for (PDPageNode pDPageNode : this.getKids()) {
            PDPage pDPage = pDPageNode.getFirstPage();
            if (pDPage == null) continue;
            return pDPage;
        }
        return null;
    }

    public List getGenericChildren() {
        return this.getKids();
    }

    public List getKids() {
        ArrayList<COSBasedObject> arrayList = null;
        if (this.cachedKids != null) {
            arrayList = this.cachedKids.get();
        }
        if (arrayList == null) {
            arrayList = new ArrayList<COSBasedObject>();
            COSArray cOSArray = this.cosGetField(DK_Kids).asArray();
            if (cOSArray != null) {
                Iterator iterator = cOSArray.iterator();
                while (iterator.hasNext()) {
                    COSBasedObject cOSBasedObject = PDPageNode.META.createFromCos((COSObject)iterator.next());
                    if (cOSBasedObject == null) continue;
                    arrayList.add(cOSBasedObject);
                }
                cOSArray.addObjectListener(this);
            }
            this.cachedKids = new SoftReference(arrayList);
        }
        return arrayList;
    }

    public PDPageNode getLastNode() {
        List list = this.getKids();
        if (list.isEmpty()) {
            return null;
        }
        return (PDPageNode)list.get(list.size() - 1);
    }

    public PDPage getLastPage() {
        List list = this.getKids();
        int n = list.size() - 1;
        while (n >= 0) {
            PDPageNode pDPageNode = (PDPageNode)list.get(n);
            PDPage pDPage = pDPageNode.getLastPage();
            if (pDPage != null) {
                return pDPage;
            }
            --n;
        }
        return null;
    }

    protected PDPageNode getNextNode(PDPageNode pDPageNode) {
        List list = this.getKids();
        int n = list.indexOf(pDPageNode);
        if (n < 0) {
            return null;
        }
        if (n < list.size() - 1) {
            return (PDPageNode)list.get(n + 1);
        }
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().getNextNode(this);
    }

    protected PDPage getNextPage(PDPage pDPage) {
        PDPage pDPage2 = null;
        PDPageNode pDPageNode = this.getNextNode(pDPage);
        while (pDPageNode != null) {
            pDPage2 = pDPageNode.getFirstPage();
            if (pDPage2 != null) break;
            pDPageNode = pDPageNode.getNextNode();
        }
        return pDPage2;
    }

    protected int getNodeIndex(PDPageNode pDPageNode) {
        int n = 0;
        for (PDPageNode pDPageNode2 : this.getKids()) {
            if (pDPageNode2 == pDPageNode) break;
            n += pDPageNode2.getCount();
        }
        PDPageTree pDPageTree = this.getParent();
        if (pDPageTree == null) {
            return n;
        }
        return n + pDPageTree.getNodeIndex(this);
    }

    protected PDPageNode getPreviousNode(PDPageNode pDPageNode) {
        List list = this.getKids();
        int n = list.indexOf(pDPageNode);
        if (n < 0) {
            return null;
        }
        if (n > 0) {
            return (PDPageNode)list.get(n - 1);
        }
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().getPreviousNode(this);
    }

    protected PDPage getPreviousPage(PDPage pDPage) {
        PDPage pDPage2 = null;
        PDPageNode pDPageNode = this.getPreviousNode(pDPage);
        while (pDPageNode != null) {
            pDPage2 = pDPageNode.getLastPage();
            if (pDPage2 != null) break;
            pDPageNode = pDPageNode.getPreviousNode();
        }
        return pDPage2;
    }

    protected void incrementCount(int n) {
        int n2 = this.getCount();
        this.cosSetField(DK_Count, COSInteger.create(n2 + n));
        if (this.getParent() != null) {
            this.getParent().incrementCount(n);
        }
    }

    protected void initializeFromScratch() {
        super.initializeFromScratch();
        this.cosSetField(DK_Kids, COSArray.create());
        this.cosSetField(DK_Count, COSInteger.create(0));
    }

    public void invalidateCaches() {
        super.invalidateCaches();
        COSArray cOSArray = this.cosGetField(DK_Kids).asArray();
        if (cOSArray != null) {
            cOSArray.removeObjectListener(this);
        }
        this.cachedKids = null;
    }

    public boolean isPage() {
        return false;
    }

    public boolean isValid() {
        PDPageTree pDPageTree = this.getParent();
        if (pDPageTree == null) {
            PDDocument pDDocument = this.getDoc();
            if (pDDocument == null) {
                return false;
            }
            return pDDocument.getPageTree() == this;
        }
        return pDPageTree.isValid();
    }

    public PDPageTree rebalance() {
        COSArray cOSArray = this.cosGetField(DK_Kids).asArray();
        if (cOSArray == null) {
            return null;
        }
        if (cOSArray.size() > 1000) {
            PDPageTree pDPageTree = (PDPageTree)META.createNew();
            if (this.getParent() != null) {
                this.getParent().exchangeNode(this, pDPageTree);
            }
            pDPageTree.addNode(this);
            return pDPageTree;
        }
        return null;
    }

    public void removeNode(PDPageNode pDPageNode) {
        COSArray cOSArray = this.cosGetField(DK_Kids).asArray();
        if (cOSArray != null && cOSArray.remove(pDPageNode.cosGetObject())) {
            this.incrementCount(-pDPageNode.getCount());
            pDPageNode.setParent(null);
        }
    }

    protected void setCount(int n) {
        int n2 = this.getCount();
        this.setFieldInt(DK_Count, n);
        if (this.getParent() != null) {
            this.getParent().incrementCount(n - n2);
        }
    }

    public static class MetaClass
    extends PDPageNode.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }

        protected COSBasedObject doCreateCOSBasedObject(COSObject cOSObject) {
            return new PDPageTree(cOSObject);
        }
    }
}

