/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.postscript;

public class TokenMgrError
extends Error {
    static final int INVALID_LEXICAL_STATE = 2;
    static final int LEXICAL_ERROR = 0;
    static final int LOOP_DETECTED = 3;
    static final int STATIC_LEXER_ERROR = 1;
    int errorCode;

    protected static final String addEscapes(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < string.length()) {
            switch (string.charAt(n)) {
                case '\u0000': {
                    break;
                }
                case '\b': {
                    stringBuilder.append("\\b");
                    break;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    break;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    break;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    break;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    break;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    break;
                }
                case '\'': {
                    stringBuilder.append("\\'");
                    break;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    break;
                }
                default: {
                    char c = string.charAt(n);
                    if (c < ' ' || c > '~') {
                        String string2 = "0000" + Integer.toString(c, 16);
                        stringBuilder.append("\\u" + string2.substring(string2.length() - 4, string2.length()));
                        break;
                    }
                    stringBuilder.append(c);
                }
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    protected static String LexicalError(boolean bl, int n, int n2, int n3, String string, char c) {
        return "Lexical error at line " + n2 + ", column " + n3 + ".  Encountered: " + (bl ? "<EOF> " : "\"" + TokenMgrError.addEscapes(String.valueOf(c)) + "\"" + " (" + c + "), ") + "after : \"" + TokenMgrError.addEscapes(string) + "\"";
    }

    public TokenMgrError() {
    }

    public TokenMgrError(boolean bl, int n, int n2, int n3, String string, char c, int n4) {
        this(TokenMgrError.LexicalError(bl, n, n2, n3, string, c), n4);
    }

    public TokenMgrError(String string, int n) {
        super(string);
        this.errorCode = n;
    }

    public String getMessage() {
        return super.getMessage();
    }
}

