/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.st;

import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.crypt.ISystemSecurityHandler;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.st.COSObjectStream;
import de.intarsys.pdf.st.IXRefEntryVisitor;
import de.intarsys.pdf.st.STDocument;
import de.intarsys.pdf.st.STXRefEntry;
import de.intarsys.pdf.st.STXRefEntryOccupied;
import de.intarsys.pdf.st.XRefEntryVisitorException;
import java.io.IOException;

public class STXRefEntryCompressed
extends STXRefEntry {
    private final int streamObjectNumber;
    private final short streamGenerationNumber;
    private int index;

    public STXRefEntryCompressed(int n, int n2, int n3, int n4, int n5) {
        super(n, n2);
        this.streamObjectNumber = n3;
        this.streamGenerationNumber = (short)n4;
        this.index = n5;
    }

    public void accept(IXRefEntryVisitor iXRefEntryVisitor) throws XRefEntryVisitorException {
        iXRefEntryVisitor.visitFromCompressed(this);
    }

    public STXRefEntry copy() {
        return new STXRefEntryCompressed(this.getObjectNumber(), this.getGenerationNumber(), this.getStreamObjectNumber(), this.getStreamGenerationNumber(), this.getIndex());
    }

    public STXRefEntryOccupied fill(int n) {
        return null;
    }

    public long getColumn1() {
        return 0L;
    }

    public int getColumn2() {
        return 0;
    }

    public int getIndex() {
        return this.index;
    }

    public int getStreamGenerationNumber() {
        return this.streamGenerationNumber & 0xFFFF;
    }

    public int getStreamObjectNumber() {
        return this.streamObjectNumber;
    }

    public boolean isFree() {
        return false;
    }

    public COSObject load(STDocument sTDocument, ISystemSecurityHandler iSystemSecurityHandler) throws IOException, COSLoadException {
        COSIndirectObject cOSIndirectObject = sTDocument.getObjectReference(this.getStreamObjectNumber(), this.getStreamGenerationNumber());
        COSObject cOSObject = cOSIndirectObject.dereference();
        if (cOSObject != null && !cOSObject.isNull()) {
            COSObjectStream cOSObjectStream = (COSObjectStream)COSObjectStream.META.createFromCos(cOSObject);
            return cOSObjectStream.loadObject(this.index, sTDocument.getParser());
        }
        return null;
    }

    protected void unlink() {
    }
}

