/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cds;

import de.intarsys.pdf.cds.CDSBase;
import de.intarsys.pdf.cos.COSString;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CDSDate
extends CDSBase {
    public static final String DATE_FORMAT = "'D':yyyyMMddHHmmss";
    public static final Pattern DatePattern = Pattern.compile("D:(\\d{4})(\\d{2})(\\d{2})(\\d{2})(\\d{2})(\\d{2})(\\+|-|Z|z)?(\\d{2})?\\'?(\\d{2})?.*");
    private static final DateFormat PDF_DATE_FORMAT = new SimpleDateFormat("'D':yyyyMMddHHmmss");
    private static final DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);

    public static CDSDate createFromCOS(COSString cOSString) {
        if (cOSString == null) {
            return null;
        }
        return new CDSDate(cOSString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(CDSDate cDSDate) {
        DateFormat dateFormat = CDSDate.dateFormat;
        synchronized (dateFormat) {
            return CDSDate.format(CDSDate.dateFormat, cDSDate);
        }
    }

    public static String format(Format format, CDSDate cDSDate) {
        String string = "";
        if (cDSDate != null) {
            try {
                string = format.format(cDSDate.toDate());
            }
            catch (ParseException parseException) {
                string = cDSDate.toString();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date toDate(String string) throws ParseException {
        DateFormat dateFormat = PDF_DATE_FORMAT;
        synchronized (dateFormat) {
            return PDF_DATE_FORMAT.parse(string);
        }
    }

    public static Date toDateWithZone(String string) throws ParseException {
        Matcher matcher = DatePattern.matcher(string);
        if (matcher.matches()) {
            int n = Integer.valueOf(matcher.group(1));
            int n2 = Integer.valueOf(matcher.group(2)) - 1;
            int n3 = Integer.valueOf(matcher.group(3));
            int n4 = Integer.valueOf(matcher.group(4));
            int n5 = Integer.valueOf(matcher.group(5));
            int n6 = Integer.valueOf(matcher.group(6));
            int n7 = 0;
            int n8 = 0;
            if (matcher.group(9) != null) {
                n8 = Integer.valueOf(matcher.group(9));
            }
            if (matcher.group(8) != null) {
                n7 = Integer.valueOf(matcher.group(8));
            }
            if (matcher.group(7) != null) {
                String string2 = matcher.group(7);
                if (string2.toLowerCase().equals("z")) {
                    n7 = 0;
                    n8 = 0;
                } else if ("-".equals(string2)) {
                    n7 *= -1;
                    n8 *= -1;
                }
                n4 -= n7;
                n5 -= n8;
            }
            int n9 = TimeZone.getDefault().getOffset(System.currentTimeMillis());
            boolean bl = TimeZone.getDefault().inDaylightTime(new Date());
            GregorianCalendar gregorianCalendar = new GregorianCalendar(n, n2, n3);
            boolean bl2 = TimeZone.getDefault().inDaylightTime(gregorianCalendar.getTime());
            if (bl) {
                if (!bl2) {
                    n9 -= TimeZone.getDefault().getDSTSavings();
                }
            } else if (bl2) {
                n9 += TimeZone.getDefault().getDSTSavings();
            }
            n7 = Math.abs((n9 /= 60000) / 60);
            n8 = n9 % 60;
            if (n9 < 0) {
                n4 -= n7;
                n5 -= n8;
            } else {
                n4 += n7;
                n5 += n8;
            }
            GregorianCalendar gregorianCalendar2 = new GregorianCalendar(n, n2, n3, n4, n5, n6);
            return gregorianCalendar2.getTime();
        }
        throw new ParseException("can't parse date string '" + string + "'", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Date date) {
        DateFormat dateFormat = PDF_DATE_FORMAT;
        synchronized (dateFormat) {
            return PDF_DATE_FORMAT.format(date);
        }
    }

    public static String toStringWithZone(Date date) {
        return CDSDate.toStringWithZone(date, TimeZone.getDefault());
    }

    public static String toStringWithZone(Date date, TimeZone timeZone) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(CDSDate.toString(date));
        int n = timeZone.getOffset(date.getTime());
        if (n < 0) {
            stringBuilder.append("-");
        } else if (n > 0) {
            stringBuilder.append("+");
        } else {
            stringBuilder.append("Z");
        }
        int n2 = Math.abs(n / 3600000);
        if (n2 / 10 < 1) {
            stringBuilder.append("0");
        }
        stringBuilder.append(n2);
        stringBuilder.append("'00'");
        return stringBuilder.toString();
    }

    public CDSDate() {
        super(COSString.create(CDSDate.toStringWithZone(new Date())));
    }

    protected CDSDate(COSString cOSString) {
        super(cOSString);
    }

    public String stringValue() {
        return ((COSString)this.cosGetObject()).stringValue();
    }

    public Date toDate() throws ParseException {
        return CDSDate.toDateWithZone(this.stringValue());
    }

    public String toFormattedString() {
        return CDSDate.format(this);
    }
}

