/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.content;

import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.content.CSError;
import de.intarsys.pdf.content.CSException;
import de.intarsys.pdf.content.CSNotSupported;
import de.intarsys.pdf.content.GraphicsState;
import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.content.ICSInterpreter;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDExtGState;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.pd.PDPattern;
import de.intarsys.pdf.pd.PDPostScript;
import de.intarsys.pdf.pd.PDShading;
import de.intarsys.pdf.pd.PDXObject;

public abstract class CSDeviceFilter
implements ICSDevice {
    private final ICSDevice device;

    public CSDeviceFilter(ICSDevice iCSDevice) {
        this.device = iCSDevice;
    }

    public void close() {
        this.getDevice().close();
    }

    public void compatibilityBegin() {
        this.getDevice().compatibilityBegin();
    }

    public void compatibilityEnd() {
        this.getDevice().compatibilityEnd();
    }

    protected void doForm(COSName cOSName, PDForm pDForm) throws CSException {
        this.saveState();
        try {
            CDSMatrix cDSMatrix = pDForm.getMatrix();
            if (cDSMatrix != null) {
                this.transform(cDSMatrix.getA(), cDSMatrix.getB(), cDSMatrix.getC(), cDSMatrix.getD(), cDSMatrix.getE(), cDSMatrix.getF());
            }
            CDSRectangle cDSRectangle = pDForm.getBoundingBox();
            if (this.getInterpreter() != null) {
                this.getInterpreter().process(pDForm.getContentStream(), pDForm.getResources());
            }
        }
        finally {
            this.restoreState();
        }
    }

    protected void doImage(COSName cOSName, PDImage pDImage) throws CSException {
        this.getDevice().doXObject(cOSName, pDImage);
    }

    protected void doPostScript(COSName cOSName, PDPostScript pDPostScript) throws CSException {
    }

    public void doShading(COSName cOSName, PDShading pDShading) {
        this.getDevice().doShading(cOSName, pDShading);
    }

    public void doXObject(COSName cOSName, PDXObject pDXObject) {
        if (pDXObject == null) {
            return;
        }
        if (pDXObject.isForm()) {
            try {
                this.doForm(cOSName, (PDForm)pDXObject);
            }
            catch (CSException cSException) {
                throw cSException;
            }
            catch (Exception exception) {
                throw new CSError("Unexpected error rendering form", exception);
            }
        } else if (pDXObject.isImage()) {
            try {
                this.doImage(cOSName, (PDImage)pDXObject);
            }
            catch (CSException cSException) {
                throw cSException;
            }
            catch (Exception exception) {
                throw new CSError("Unexpected error rendering image", exception);
            }
        } else if (pDXObject.isPostscript()) {
            try {
                this.doPostScript(cOSName, (PDPostScript)pDXObject);
            }
            catch (CSException cSException) {
                throw cSException;
            }
            catch (Exception exception) {
                throw new CSError("Unexpected error rendering postscript", exception);
            }
        } else {
            throw new CSNotSupported("unknown XObject type");
        }
    }

    public ICSDevice getDevice() {
        return this.device;
    }

    public GraphicsState getGraphicsState() {
        return this.getDevice().getGraphicsState();
    }

    public ICSInterpreter getInterpreter() {
        return this.getDevice().getInterpreter();
    }

    public void inlineImage(PDImage pDImage) {
        this.getDevice().inlineImage(pDImage);
    }

    public void markedContentBegin(COSName cOSName) {
        this.getDevice().markedContentBegin(cOSName);
    }

    public void markedContentBeginProperties(COSName cOSName, COSName cOSName2, COSDictionary cOSDictionary) {
        this.getDevice().markedContentBeginProperties(cOSName, cOSName2, cOSDictionary);
    }

    public void markedContentEnd() {
        this.getDevice().markedContentEnd();
    }

    public void markedContentPoint(COSName cOSName) {
        this.getDevice().markedContentPoint(cOSName);
    }

    public void markedContentPointProperties(COSName cOSName, COSName cOSName2, COSDictionary cOSDictionary) {
        this.getDevice().markedContentPointProperties(cOSName, cOSName2, cOSDictionary);
    }

    public void open(ICSInterpreter iCSInterpreter) {
        this.getDevice().open(iCSInterpreter);
    }

    public void pathClipEvenOdd() {
        this.getDevice().pathClipEvenOdd();
    }

    public void pathClipNonZero() {
        this.getDevice().pathClipNonZero();
    }

    public void pathClose() {
        this.getDevice().pathClose();
    }

    public void pathCloseFillStrokeEvenOdd() {
        this.getDevice().pathCloseFillStrokeEvenOdd();
    }

    public void pathCloseFillStrokeNonZero() {
        this.getDevice().pathCloseFillStrokeNonZero();
    }

    public void pathCloseStroke() {
        this.getDevice().pathCloseStroke();
    }

    public void pathEnd() {
        this.getDevice().pathEnd();
    }

    public void pathFillEvenOdd() {
        this.getDevice().pathFillEvenOdd();
    }

    public void pathFillNonZero() {
        this.getDevice().pathFillNonZero();
    }

    public void pathFillStrokeEvenOdd() {
        this.getDevice().pathFillStrokeEvenOdd();
    }

    public void pathFillStrokeNonZero() {
        this.getDevice().pathFillStrokeNonZero();
    }

    public void pathStroke() {
        this.getDevice().pathStroke();
    }

    public void penCurveToC(float f, float f2, float f3, float f4, float f5, float f6) {
        this.getDevice().penCurveToC(f, f2, f3, f4, f5, f6);
    }

    public void penCurveToV(float f, float f2, float f3, float f4) {
        this.getDevice().penCurveToV(f, f2, f3, f4);
    }

    public void penCurveToY(float f, float f2, float f3, float f4) {
        this.getDevice().penCurveToY(f, f2, f3, f4);
    }

    public void penLineTo(float f, float f2) {
        this.getDevice().penLineTo(f, f2);
    }

    public void penMoveTo(float f, float f2) {
        this.getDevice().penMoveTo(f, f2);
    }

    public void penRectangle(float f, float f2, float f3, float f4) {
        this.getDevice().penRectangle(f, f2, f3, f4);
    }

    public void restoreState() {
        this.getDevice().restoreState();
    }

    public void saveState() {
        this.getDevice().saveState();
    }

    public void setExtendedState(COSName cOSName, PDExtGState pDExtGState) {
        this.getDevice().setExtendedState(cOSName, pDExtGState);
    }

    public void setFlatnessTolerance(float f) {
        this.getDevice().setFlatnessTolerance(f);
    }

    public void setLineCap(int n) {
        this.getDevice().setLineCap(n);
    }

    public void setLineDash(float[] fArray, float f) {
        this.getDevice().setLineDash(fArray, f);
    }

    public void setLineJoin(int n) {
        this.getDevice().setLineJoin(n);
    }

    public void setLineWidth(float f) {
        this.getDevice().setLineWidth(f);
    }

    public void setMiterLimit(float f) {
        this.getDevice().setMiterLimit(f);
    }

    public void setNonStrokeColorCMYK(float f, float f2, float f3, float f4) {
        this.getDevice().setNonStrokeColorCMYK(f, f2, f3, f4);
    }

    public void setNonStrokeColorGray(float f) {
        this.getDevice().setNonStrokeColorGray(f);
    }

    public void setNonStrokeColorRGB(float f, float f2, float f3) {
        this.getDevice().setNonStrokeColorRGB(f, f2, f3);
    }

    public void setNonStrokeColorSpace(COSName cOSName, PDColorSpace pDColorSpace) {
        this.getDevice().setNonStrokeColorSpace(cOSName, pDColorSpace);
    }

    public void setNonStrokeColorValues(float[] fArray) {
        this.getDevice().setNonStrokeColorValues(fArray);
    }

    public void setNonStrokeColorValues(float[] fArray, COSName cOSName, PDPattern pDPattern) {
        this.getDevice().setNonStrokeColorValues(fArray, cOSName, pDPattern);
    }

    public void setRenderingIntent(COSName cOSName) {
        this.getDevice().setRenderingIntent(cOSName);
    }

    public void setStrokeColorCMYK(float f, float f2, float f3, float f4) {
        this.getDevice().setStrokeColorCMYK(f, f2, f3, f4);
    }

    public void setStrokeColorGray(float f) {
        this.getDevice().setStrokeColorGray(f);
    }

    public void setStrokeColorRGB(float f, float f2, float f3) {
        this.getDevice().setStrokeColorRGB(f, f2, f3);
    }

    public void setStrokeColorSpace(COSName cOSName, PDColorSpace pDColorSpace) {
        this.getDevice().setStrokeColorSpace(cOSName, pDColorSpace);
    }

    public void setStrokeColorValues(float[] fArray) {
        this.getDevice().setStrokeColorValues(fArray);
    }

    public void setStrokeColorValues(float[] fArray, COSName cOSName, PDPattern pDPattern) {
        this.getDevice().setStrokeColorValues(fArray, cOSName, pDPattern);
    }

    public void textBegin() {
        this.getDevice().textBegin();
    }

    public void textEnd() {
        this.getDevice().textEnd();
    }

    public void textLineMove(float f, float f2) {
        this.getDevice().textLineMove(f, f2);
    }

    public void textLineNew() {
        this.getDevice().textLineNew();
    }

    public void textMove(float f, float f2) {
        this.getDevice().textMove(f, f2);
    }

    public void textMoveTo(float f, float f2) {
        this.getDevice().textMoveTo(f, f2);
    }

    public void textSetCharSpacing(float f) {
        this.getDevice().textSetCharSpacing(f);
    }

    public void textSetFont(COSName cOSName, PDFont pDFont, float f) {
        this.getDevice().textSetFont(cOSName, pDFont, f);
    }

    public void textSetHorizontalScaling(float f) {
        this.getDevice().textSetHorizontalScaling(f);
    }

    public void textSetLeading(float f) {
        this.getDevice().textSetLeading(f);
    }

    public void textSetRenderingMode(int n) {
        this.getDevice().textSetRenderingMode(n);
    }

    public void textSetRise(float f) {
        this.getDevice().textSetRise(f);
    }

    public void textSetTransform(float f, float f2, float f3, float f4, float f5, float f6) {
        this.getDevice().textSetTransform(f, f2, f3, f4, f5, f6);
    }

    public void textSetWordSpacing(float f) {
        this.getDevice().textSetWordSpacing(f);
    }

    public void textShow(byte[] byArray, int n, int n2) {
        this.getDevice().textShow(byArray, n, n2);
    }

    public void textShow(char[] cArray, int n, int n2) {
        this.getDevice().textShow(cArray, n, n2);
    }

    public void textShow(String string) {
        this.getDevice().textShow(string);
    }

    public void textT3SetGlyphWidth(float f, float f2) {
        this.getDevice().textT3SetGlyphWidth(f, f2);
    }

    public void textT3SetGlyphWidthBB(float f, float f2, float f3, float f4, float f5, float f6) {
        this.getDevice().textT3SetGlyphWidthBB(f, f2, f3, f4, f5, f6);
    }

    public void transform(float f, float f2, float f3, float f4, float f5, float f6) {
        this.getDevice().transform(f, f2, f3, f4, f5, f6);
    }
}

