/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cos;

import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSDocumentElement;
import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.ICOSContainer;
import de.intarsys.pdf.cos.ICOSObjectListener;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class COSCompositeObject
extends COSObject
implements ICOSContainer,
IAttributeSupport {
    protected AttributeMap attributes;
    protected List objectListeners;

    protected COSCompositeObject() {
    }

    public void addObjectListener(ICOSObjectListener iCOSObjectListener) {
        ArrayList<ICOSObjectListener> arrayList = this.objectListeners == null ? new ArrayList<ICOSObjectListener>() : new ArrayList(this.objectListeners);
        arrayList.add(iCOSObjectListener);
        this.objectListeners = arrayList;
    }

    public ICOSContainer associate(ICOSContainer iCOSContainer, COSObject cOSObject) {
        if (iCOSContainer == this) {
            return this;
        }
        throw new IllegalStateException("object may only be contained once (use indirect object)");
    }

    public COSDocumentElement containable(COSObject cOSObject) {
        return cOSObject;
    }

    public final COSObject copyDeep() {
        return this.copyDeep(new HashMap());
    }

    public COSObject copyDeep(Map map) {
        COSObject cOSObject = this.copyBasic();
        if (this.isIndirect()) {
            cOSObject.beIndirect();
            map.put(this.getIndirectObject(), cOSObject);
        }
        return cOSObject;
    }

    public ICOSContainer disassociate(ICOSContainer iCOSContainer, COSObject cOSObject) {
        if (iCOSContainer == this) {
            cOSObject.basicSetContainer(COSObject.NULL_CONTAINER);
            return COSObject.NULL_CONTAINER;
        }
        throw new IllegalStateException("association inconsistent");
    }

    public synchronized Object getAttribute(Object object) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.getAttribute(object);
    }

    public void harden(COSObject cOSObject) {
        this.container.harden(cOSObject);
    }

    public boolean isObjectListenerAvailable() {
        if (this.objectListeners == null) {
            return false;
        }
        return !this.objectListeners.isEmpty();
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean mayBeSwapped() {
        return true;
    }

    public int referenceCount() {
        return 1;
    }

    public COSIndirectObject referenceIndirect(COSObject cOSObject) {
        return COSIndirectObject.create(cOSObject);
    }

    public void register(COSDocumentElement cOSDocumentElement) {
        COSDocument cOSDocument = this.getDoc();
        if (cOSDocument != null) {
            cOSDocumentElement.registerWith(cOSDocument);
        }
    }

    protected void registerWith(COSDocument cOSDocument) {
        Iterator<COSDocumentElement> iterator = this.basicIterator();
        while (iterator.hasNext()) {
            COSDocumentElement cOSDocumentElement = iterator.next();
            cOSDocumentElement.registerWith(cOSDocument);
        }
    }

    public synchronized Object removeAttribute(Object object) {
        if (this.attributes != null) {
            this.attributes.removeAttribute(object);
        }
        return null;
    }

    public void removeObjectListener(ICOSObjectListener iCOSObjectListener) {
        if (this.objectListeners == null) {
            return;
        }
        ArrayList arrayList = new ArrayList(this.objectListeners);
        arrayList.remove(iCOSObjectListener);
        this.objectListeners = arrayList;
    }

    public ICOSContainer restoreStateContainer(ICOSContainer iCOSContainer) {
        return iCOSContainer;
    }

    public ICOSContainer saveStateContainer() {
        return this;
    }

    public synchronized Object setAttribute(Object object, Object object2) {
        if (this.attributes == null) {
            this.attributes = new AttributeMap(1);
        }
        return this.attributes.setAttribute(object, object2);
    }

    public void soften(COSObject cOSObject) {
        this.container.soften(cOSObject);
    }

    protected void triggerChanged(Object object, Object object2, Object object3) {
        if (this.objectListeners == null) {
            return;
        }
        for (ICOSObjectListener iCOSObjectListener : this.objectListeners) {
            iCOSObjectListener.changed(this, object, object2, object3);
        }
    }

    public void willChange(COSObject cOSObject) {
        this.container.willChange(cOSObject);
    }
}

