/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cos;

import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSPrimitiveObject;
import de.intarsys.pdf.cos.COSVisitorException;
import de.intarsys.pdf.cos.ICOSObjectVisitor;
import de.intarsys.pdf.encoding.PDFDocEncoding;
import de.intarsys.tools.hex.HexTools;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class COSString
extends COSPrimitiveObject
implements Comparable {
    private static String LINE_SEPARATOR = System.getProperty("line.separator");
    private String encoding;
    private byte[] bytes;
    private int hash = 0;
    private boolean hexMode = false;
    private byte offset = 0;
    private String string;

    public static COSString create(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("COSString value can't be null");
        }
        return new COSString(byArray, null);
    }

    public static COSString create(byte[] byArray, String string) {
        if (byArray == null) {
            throw new NullPointerException("COSString value can't be null");
        }
        return new COSString(byArray, string);
    }

    public static COSString create(String string) {
        if (string == null) {
            throw new NullPointerException("COSString value can't be null");
        }
        if (PDFDocEncoding.UNIQUE.isEncodable(string)) {
            return new COSString(string, null);
        }
        return new COSString(string, "UTF-16BE");
    }

    public static COSString create(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("COSString value can't be null");
        }
        return new COSString(string, string2);
    }

    public static COSString createHex(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("COSString value can't be null");
        }
        COSString cOSString = new COSString(byArray, null);
        cOSString.setHexMode(true);
        return cOSString;
    }

    public static COSString createHex(byte[] byArray, String string) {
        if (byArray == null) {
            throw new NullPointerException("COSString value can't be null");
        }
        COSString cOSString = new COSString(byArray, string);
        cOSString.setHexMode(true);
        return cOSString;
    }

    public static COSString createHex(String string) {
        if (string == null) {
            throw new NullPointerException("COSString value can't be null");
        }
        if (PDFDocEncoding.UNIQUE.isEncodable(string)) {
            COSString cOSString = new COSString(string, null);
            cOSString.setHexMode(true);
            return cOSString;
        }
        COSString cOSString = new COSString(string, "UTF-16BE");
        cOSString.setHexMode(true);
        return cOSString;
    }

    public static COSString createHex(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("COSString value can't be null");
        }
        COSString cOSString = new COSString(string, string2);
        cOSString.setHexMode(true);
        return cOSString;
    }

    public static COSString createMultiLine(String string) {
        return COSString.create(COSString.toPDFString(string));
    }

    public static String toJavaString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\r') {
                if (bl) {
                    stringBuilder.append(LINE_SEPARATOR);
                }
                bl = true;
            } else if (c == '\n') {
                stringBuilder.append(LINE_SEPARATOR);
                bl = false;
            } else {
                if (bl) {
                    stringBuilder.append(LINE_SEPARATOR);
                }
                stringBuilder.append(c);
                bl = false;
            }
            ++n2;
        }
        if (bl) {
            stringBuilder.append(LINE_SEPARATOR);
        }
        return stringBuilder.toString();
    }

    public static String toPDFString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c != '\r') {
                if (c == '\n') {
                    stringBuilder.append('\r');
                } else {
                    stringBuilder.append(c);
                }
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    protected COSString() {
    }

    protected COSString(byte[] byArray, String string) {
        this.bytes = byArray;
        this.encoding = string;
    }

    protected COSString(String string, String string2) {
        this.string = string;
        this.encoding = string2;
    }

    public Object accept(ICOSObjectVisitor iCOSObjectVisitor) throws COSVisitorException {
        return iCOSObjectVisitor.visitFromString(this);
    }

    public COSString asString() {
        return this;
    }

    protected String basicToString() {
        if (this.isHexMode()) {
            return "<" + this.hexStringValue() + ">";
        }
        return "(" + this.stringValue() + ")";
    }

    public byte[] byteValue() {
        if (this.bytes == null) {
            this.bytes = this.encode();
        }
        return this.bytes;
    }

    public void clearBytes() {
        if (this.bytes == null) {
            return;
        }
        this.decode();
        this.bytes = null;
    }

    public void clearString() {
        if (this.string == null) {
            return;
        }
        this.encode();
        this.string = null;
    }

    public int compareTo(Object object) {
        if (!(object instanceof COSString)) {
            throw new ClassCastException("must compare with a COSString");
        }
        byte[] byArray = this.byteValue();
        byte[] byArray2 = ((COSString)object).byteValue();
        int n = 0;
        while (n < byArray.length && n < byArray2.length) {
            if (byArray[n] < byArray2[n]) {
                return -1;
            }
            if (byArray[n] > byArray2[n]) {
                return 1;
            }
            ++n;
        }
        if (byArray.length < byArray2.length) {
            return -1;
        }
        if (byArray.length > byArray2.length) {
            return 1;
        }
        return 0;
    }

    protected COSObject copyBasic() {
        COSString cOSString = new COSString();
        cOSString.bytes = this.bytes;
        cOSString.hash = this.hash;
        cOSString.hexMode = this.hexMode;
        cOSString.string = this.string;
        cOSString.encoding = this.encoding;
        cOSString.offset = this.offset;
        return cOSString;
    }

    protected String decode() {
        this.testBuiltinEncoding();
        if (this.encoding != null) {
            try {
                return new String(this.bytes, (int)this.offset, this.bytes.length - this.offset, this.encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return PDFDocEncoding.UNIQUE.decode(this.bytes);
            }
        }
        return PDFDocEncoding.UNIQUE.decode(this.bytes);
    }

    protected byte[] encode() {
        if (this.encoding != null) {
            if ("UTF-16BE".equals(this.encoding)) {
                byte[] byArray;
                try {
                    byArray = this.string.getBytes("UTF-16BE");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return PDFDocEncoding.UNIQUE.encode(this.string);
                }
                byte[] byArray2 = new byte[byArray.length + 2];
                byArray2[0] = -2;
                byArray2[1] = -1;
                System.arraycopy(byArray, 0, byArray2, 2, byArray.length);
                return byArray2;
            }
            if ("UTF-16LE".equals(this.encoding)) {
                byte[] byArray;
                try {
                    byArray = this.string.getBytes("UTF-16LE");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return PDFDocEncoding.UNIQUE.encode(this.string);
                }
                byte[] byArray3 = new byte[byArray.length + 2];
                byArray3[0] = -1;
                byArray3[1] = -2;
                System.arraycopy(byArray, 0, byArray3, 2, byArray.length);
                return byArray3;
            }
            try {
                return this.string.getBytes(this.encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return PDFDocEncoding.UNIQUE.encode(this.string);
            }
        }
        return PDFDocEncoding.UNIQUE.encode(this.string);
    }

    public boolean equals(Object object) {
        if (!(object instanceof COSString)) {
            return false;
        }
        return Arrays.equals(this.byteValue(), ((COSString)object).byteValue());
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int hashCode() {
        if (this.bytes == null) {
            return super.hashCode();
        }
        int n = this.hash;
        if (n == 0) {
            int n2 = 0;
            while (n2 < this.bytes.length) {
                n = 31 * n + this.bytes[n2];
                ++n2;
            }
            this.hash = n;
        }
        return n;
    }

    public String hexStringValue() {
        return HexTools.bytesToHexString((byte[])this.byteValue());
    }

    public boolean isHexMode() {
        return this.hexMode;
    }

    public String multiLineStringValue() {
        return COSString.toJavaString(this.stringValue());
    }

    public void restoreState(Object object) {
        super.restoreState(object);
        COSString cOSString = (COSString)object;
        this.bytes = cOSString.bytes;
        this.hash = cOSString.hash;
        this.hexMode = cOSString.hexMode;
        this.string = cOSString.string;
    }

    public Object saveState() {
        COSString cOSString = new COSString();
        cOSString.bytes = this.bytes;
        cOSString.hash = this.hash;
        cOSString.hexMode = this.hexMode;
        cOSString.string = this.string;
        cOSString.encoding = this.encoding;
        cOSString.offset = this.offset;
        cOSString.container = this.container.saveStateContainer();
        return cOSString;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setHexMode(boolean bl) {
        this.hexMode = bl;
    }

    public String stringValue() {
        if (this.string == null) {
            this.string = this.decode();
        }
        return this.string;
    }

    protected void testBuiltinEncoding() {
        if (this.bytes.length < 2) {
            return;
        }
        if (this.bytes[0] == -2 && this.bytes[1] == -1) {
            this.offset = (byte)2;
            this.encoding = "UTF-16BE";
        } else if (this.bytes[0] == -1 && this.bytes[1] == -2) {
            this.offset = (byte)2;
            this.encoding = "UTF-16LE";
        }
    }
}

