/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cos;

import de.intarsys.pdf.cos.COSConverter;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.cos.COSTrailer;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.parser.PDFParser;
import de.intarsys.pdf.st.STDocument;
import de.intarsys.pdf.st.STXRefSection;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorViewport;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class COSTools {
    @Deprecated
    public static COSObject createObject(Object object) {
        return COSConverter.toCos(object);
    }

    public static List<Revision> getRevisions(COSDocument cOSDocument) throws IOException, COSLoadException {
        ArrayList<Revision> arrayList = new ArrayList<Revision>();
        STDocument sTDocument = cOSDocument.stGetDoc();
        STXRefSection sTXRefSection = sTDocument.getXRefSection();
        if (sTDocument.getRandomAccess() == null) {
            return arrayList;
        }
        ArrayList<STXRefSection> arrayList2 = new ArrayList<STXRefSection>();
        while (sTXRefSection != null) {
            arrayList2.add(sTXRefSection);
            sTXRefSection = sTXRefSection.getPrevious();
        }
        Collections.sort(arrayList2, new Comparator<STXRefSection>(){

            @Override
            public int compare(STXRefSection sTXRefSection, STXRefSection sTXRefSection2) {
                if (sTXRefSection.getOffset() < sTXRefSection2.getOffset()) {
                    return 1;
                }
                if (sTXRefSection.getOffset() > sTXRefSection2.getOffset()) {
                    return -1;
                }
                return 0;
            }
        });
        long l = -1L;
        for (STXRefSection sTXRefSection2 : arrayList2) {
            long l2;
            COSDictionary cOSDictionary = sTXRefSection2.cosGetDict();
            if (cOSDictionary.get(COSTrailer.DK_Root).isNull()) continue;
            long l3 = l;
            if (l3 == -1L) {
                l3 = sTDocument.getRandomAccess().getLength();
            }
            if ((l2 = COSTools.searchNextEOF(sTDocument.getRandomAccess(), sTXRefSection2.getOffset(), l3)) == -1L) continue;
            Revision revision = new Revision();
            revision.setXRefSection(sTXRefSection2);
            revision.setLength(l2);
            arrayList.add(revision);
            l = l2;
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    public static List<Revision> getSubsequentRevisions(COSDocument cOSDocument, STXRefSection sTXRefSection) throws IOException, COSLoadException {
        List<Revision> list = COSTools.getRevisions(cOSDocument);
        ArrayList<Revision> arrayList = new ArrayList<Revision>();
        boolean bl = false;
        for (Revision revision : list) {
            if (bl) {
                arrayList.add(revision);
                continue;
            }
            if (revision.getXRefSection() != sTXRefSection) continue;
            bl = true;
        }
        return arrayList;
    }

    public static List<ILocator> getVersions(COSDocument cOSDocument) throws IOException, COSLoadException {
        List<Revision> list = COSTools.getRevisions(cOSDocument);
        ArrayList<ILocator> arrayList = new ArrayList<ILocator>();
        for (Revision revision : list) {
            arrayList.add(revision.createLocator());
        }
        return arrayList;
    }

    protected static boolean readUptoNewLine(IRandomAccess iRandomAccess) throws IOException {
        int n;
        do {
            if ((n = iRandomAccess.read()) != -1) continue;
            return false;
        } while (!PDFParser.isEOL(n));
        if (n == PDFParser.CHAR_CR && (n = iRandomAccess.read()) != PDFParser.CHAR_LF) {
            iRandomAccess.seekBy(-1L);
        }
        return true;
    }

    protected static long searchNextEOF(IRandomAccess iRandomAccess, long l, long l2) throws IOException, COSLoadException {
        iRandomAccess.seek(l);
        int n = 0;
        int n2 = iRandomAccess.read();
        while (n2 != -1 && iRandomAccess.getOffset() < l2) {
            if (n2 == PDFParser.TOKEN_EOF[n]) {
                if (++n == PDFParser.TOKEN_EOF.length) {
                    COSTools.readUptoNewLine(iRandomAccess);
                    return iRandomAccess.getOffset();
                }
            } else {
                n = 0;
            }
            n2 = iRandomAccess.read();
        }
        return -1L;
    }

    public static COSDictionary toDictionary(COSObject cOSObject) {
        COSDictionary cOSDictionary = null;
        if (cOSObject instanceof COSDictionary) {
            cOSDictionary = (COSDictionary)cOSObject;
        } else if (cOSObject instanceof COSStream) {
            cOSDictionary = ((COSStream)cOSObject).getDict();
        }
        return cOSDictionary;
    }

    private COSTools() {
    }

    public static class Revision {
        private STXRefSection xRefSection;
        private long length;

        public ILocator createLocator() {
            LocatorViewport locatorViewport = new LocatorViewport(this.getXRefSection().getDoc().getLocator());
            locatorViewport.setName(String.valueOf(this.getXRefSection().getDoc().getLocator().getLocalName()) + "_v" + this.getXRefSection().getIncrementalCount() + ".pdf");
            locatorViewport.setStart(0L);
            locatorViewport.setEnd(this.getLength());
            locatorViewport.setReadOnly();
            return locatorViewport;
        }

        public long getLength() {
            return this.length;
        }

        public STXRefSection getXRefSection() {
            return this.xRefSection;
        }

        public void setLength(long l) {
            this.length = l;
        }

        public void setXRefSection(STXRefSection sTXRefSection) {
            this.xRefSection = sTXRefSection;
        }
    }
}

