/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.crypt;

import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.crypt.COSEncryption;
import de.intarsys.pdf.crypt.COSSecurityException;
import de.intarsys.pdf.crypt.ISecurityHandler;
import de.intarsys.pdf.crypt.ISecurityHandlerFactory;
import de.intarsys.pdf.crypt.StandardSecurityHandlerR2;
import de.intarsys.pdf.crypt.StandardSecurityHandlerR3;
import de.intarsys.pdf.crypt.StandardSecurityHandlerR4;

public class StandardSecurityHandlerFactory
implements ISecurityHandlerFactory {
    public static final COSName CN_Standard = COSName.constant("Standard");
    public static final COSName DK_R = COSName.constant("R");

    protected StandardSecurityHandlerFactory() {
    }

    public ISecurityHandler getSecurityHandler(COSEncryption cOSEncryption) throws COSSecurityException {
        COSName cOSName = cOSEncryption.getFilter();
        if (cOSName == null) {
            throw new COSSecurityException("security handler not specified");
        }
        if (cOSName.equals(CN_Standard)) {
            int n = cOSEncryption.getFieldInt(DK_R, 0);
            if (n == 2) {
                return new StandardSecurityHandlerR2();
            }
            if (n == 3) {
                return new StandardSecurityHandlerR3();
            }
            if (n == 4) {
                return new StandardSecurityHandlerR4();
            }
            return new StandardSecurityHandlerR2();
        }
        throw new COSSecurityException("no security handler '" + cOSName.stringValue() + "'");
    }
}

