/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.crypt;

import de.intarsys.pdf.crypt.AccessPermissionsFull;
import de.intarsys.pdf.crypt.AccessPermissionsR2;
import de.intarsys.pdf.crypt.COSSecurityException;
import de.intarsys.pdf.crypt.IAccessPermissions;
import de.intarsys.pdf.crypt.StandardSecurityHandler;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class StandardSecurityHandlerR2
extends StandardSecurityHandler {
    public static final String DIGEST_ALGORITHM = "MD5";
    public static final String KEY_ALGORITHM = "RC4";
    public static final String CIPHER_ALGORITHM = "RC4";

    public boolean authenticateOwner(byte[] byArray) throws COSSecurityException {
        try {
            byte[] byArray2 = this.prepareBytes(byArray);
            MessageDigest messageDigest = MessageDigest.getInstance(DIGEST_ALGORITHM);
            messageDigest.update(byArray2);
            byte[] byArray3 = messageDigest.digest();
            int n = 5;
            byte[] byArray4 = new byte[n];
            System.arraycopy(byArray3, 0, byArray4, 0, n);
            Cipher cipher = Cipher.getInstance("RC4");
            if (cipher == null) {
                throw new COSSecurityException("RC4 cipher not found");
            }
            byte[] byArray5 = this.getO();
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray4, "RC4");
            cipher.init(2, secretKeySpec);
            byArray5 = cipher.doFinal(byArray5);
            if (this.authenticateUser(byArray5)) {
                this.setActiveAccessPermissions(AccessPermissionsFull.get());
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            throw new COSSecurityException(exception);
        }
    }

    public boolean authenticateUser(byte[] byArray) throws COSSecurityException {
        byte[] byArray2;
        byte[] byArray3 = this.getU();
        if (byArray3.length != (byArray2 = this.createUserPassword(byArray)).length) {
            return false;
        }
        int n = 0;
        while (n < byArray2.length) {
            if (byArray3[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        this.setCryptKey(this.createCryptKey(byArray));
        this.setActiveAccessPermissions(this.createAccessPermissions());
        return true;
    }

    protected IAccessPermissions createAccessPermissions() {
        return new AccessPermissionsR2(this.getPermissionFlags());
    }

    protected byte[] createCryptKey(byte[] byArray) throws COSSecurityException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(DIGEST_ALGORITHM);
            byte[] byArray2 = this.prepareBytes(byArray);
            messageDigest.update(byArray2);
            messageDigest.update(this.getO());
            messageDigest.update(this.getPBytes());
            byte[] byArray3 = this.getPermanentFileID();
            if (byArray3 != null) {
                messageDigest.update(byArray3);
            }
            byte[] byArray4 = messageDigest.digest();
            int n = 5;
            byte[] byArray5 = new byte[n];
            System.arraycopy(byArray4, 0, byArray5, 0, n);
            return byArray5;
        }
        catch (Exception exception) {
            throw new COSSecurityException(exception);
        }
    }

    protected byte[] createOwnerPassword(byte[] byArray, byte[] byArray2) throws COSSecurityException {
        try {
            byte[] byArray3 = byArray == null ? this.prepareBytes(byArray2) : this.prepareBytes(byArray);
            MessageDigest messageDigest = MessageDigest.getInstance(DIGEST_ALGORITHM);
            messageDigest.update(byArray3);
            byte[] byArray4 = messageDigest.digest();
            int n = 5;
            byte[] byArray5 = new byte[n];
            System.arraycopy(byArray4, 0, byArray5, 0, n);
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray5, "RC4");
            byte[] byArray6 = this.prepareBytes(byArray2);
            Cipher cipher = Cipher.getInstance("RC4");
            cipher.init(2, secretKeySpec);
            byte[] byArray7 = cipher.doFinal(byArray6);
            return byArray7;
        }
        catch (Exception exception) {
            throw new COSSecurityException(exception);
        }
    }

    protected byte[] createUserPassword(byte[] byArray) throws COSSecurityException {
        try {
            byte[] byArray2 = this.createCryptKey(byArray);
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, "RC4");
            Cipher cipher = Cipher.getInstance("RC4");
            cipher.init(1, secretKeySpec);
            byte[] byArray3 = cipher.doFinal(PADDING);
            return byArray3;
        }
        catch (Exception exception) {
            throw new COSSecurityException(exception);
        }
    }

    public int getRevision() {
        return 2;
    }
}

