/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.crypt;

import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.crypt.AccessPermissionsFull;
import de.intarsys.pdf.crypt.AccessPermissionsR3;
import de.intarsys.pdf.crypt.COSSecurityException;
import de.intarsys.pdf.crypt.IAccessPermissions;
import de.intarsys.pdf.crypt.StandardSecurityHandler;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class StandardSecurityHandlerR4
extends StandardSecurityHandler {
    public static final String KEY_ALGORITHM = "RC4";
    public static final String CIPHER_ALGORITHM = "RC4";
    public static final String DIGEST_ALGORITHM = "MD5";
    public static final COSName DK_AuthEvent = COSName.constant("AuthEvent");
    private static byte[] HIGH_BYTES = new byte[]{-1, -1, -1, -1};

    public boolean authenticateOwner(byte[] byArray) throws COSSecurityException {
        try {
            byte[] byArray2 = this.prepareBytes(byArray);
            MessageDigest messageDigest = MessageDigest.getInstance(DIGEST_ALGORITHM);
            messageDigest.update(byArray2);
            byte[] byArray3 = messageDigest.digest();
            int n = 0;
            while (n < 50) {
                messageDigest.update(byArray3);
                byArray3 = messageDigest.digest();
                ++n;
            }
            n = 16;
            byte[] byArray4 = new byte[n];
            System.arraycopy(byArray3, 0, byArray4, 0, n);
            Cipher cipher = Cipher.getInstance("RC4");
            if (cipher == null) {
                throw new COSSecurityException("RC4 cipher not found");
            }
            byte[] byArray5 = this.getO();
            byte[] byArray6 = new byte[byArray4.length];
            int n2 = 19;
            while (n2 >= 0) {
                int n3 = 0;
                while (n3 < byArray4.length) {
                    byArray6[n3] = (byte)(byArray4[n3] ^ n2);
                    ++n3;
                }
                SecretKeySpec secretKeySpec = new SecretKeySpec(byArray6, "RC4");
                cipher.init(2, secretKeySpec);
                byArray5 = cipher.doFinal(byArray5);
                --n2;
            }
            if (this.authenticateUser(byArray5)) {
                this.setActiveAccessPermissions(AccessPermissionsFull.get());
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            throw new COSSecurityException(exception);
        }
    }

    public boolean authenticateUser(byte[] byArray) throws COSSecurityException {
        byte[] byArray2;
        byte[] byArray3 = this.getU();
        if (byArray3.length != (byArray2 = this.createUserPassword(byArray)).length) {
            return false;
        }
        int n = 16;
        int n2 = 0;
        while (n2 < n) {
            if (byArray3[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        this.setCryptKey(this.createCryptKey(byArray));
        this.setActiveAccessPermissions(this.createAccessPermissions());
        return true;
    }

    protected IAccessPermissions createAccessPermissions() {
        return new AccessPermissionsR3(this.getPermissionFlags());
    }

    protected byte[] createCryptKey(byte[] byArray) throws COSSecurityException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(DIGEST_ALGORITHM);
            byte[] byArray2 = this.prepareBytes(byArray);
            messageDigest.update(byArray2);
            messageDigest.update(this.getO());
            messageDigest.update(this.getPBytes());
            byte[] byArray3 = this.getPermanentFileID();
            if (byArray3 != null) {
                messageDigest.update(byArray3);
            }
            if (!this.isEncryptMetadata()) {
                messageDigest.update(HIGH_BYTES);
            }
            byte[] byArray4 = messageDigest.digest();
            int n = 16;
            int n2 = 0;
            while (n2 < 50) {
                messageDigest.update(byArray4, 0, n);
                byArray4 = messageDigest.digest();
                ++n2;
            }
            byte[] byArray5 = new byte[n];
            System.arraycopy(byArray4, 0, byArray5, 0, n);
            return byArray5;
        }
        catch (Exception exception) {
            throw new COSSecurityException(exception);
        }
    }

    protected byte[] createOwnerPassword(byte[] byArray, byte[] byArray2) throws COSSecurityException {
        try {
            byte[] byArray3 = byArray == null ? this.prepareBytes(byArray2) : this.prepareBytes(byArray);
            MessageDigest messageDigest = MessageDigest.getInstance(DIGEST_ALGORITHM);
            messageDigest.update(byArray3);
            byte[] byArray4 = messageDigest.digest();
            int n = 16;
            int n2 = 0;
            while (n2 < 50) {
                messageDigest.update(byArray4, 0, n);
                byArray4 = messageDigest.digest();
                ++n2;
            }
            byte[] byArray5 = new byte[n];
            System.arraycopy(byArray4, 0, byArray5, 0, n);
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray5, "RC4");
            byte[] byArray6 = this.prepareBytes(byArray2);
            Cipher cipher = Cipher.getInstance("RC4");
            cipher.init(2, secretKeySpec);
            byte[] byArray7 = cipher.doFinal(byArray6);
            byte[] byArray8 = new byte[byArray5.length];
            int n3 = 1;
            while (n3 <= 19) {
                int n4 = 0;
                while (n4 < byArray5.length) {
                    byArray8[n4] = (byte)(byArray5[n4] ^ n3);
                    ++n4;
                }
                secretKeySpec = new SecretKeySpec(byArray8, "RC4");
                cipher.init(1, secretKeySpec);
                byArray7 = cipher.doFinal(byArray7);
                ++n3;
            }
            return byArray7;
        }
        catch (Exception exception) {
            throw new COSSecurityException(exception);
        }
    }

    protected byte[] createUserPassword(byte[] byArray) throws COSSecurityException {
        try {
            byte[] byArray2 = this.createCryptKey(byArray);
            MessageDigest messageDigest = MessageDigest.getInstance(DIGEST_ALGORITHM);
            messageDigest.update(PADDING);
            byte[] byArray3 = this.getPermanentFileID();
            if (byArray3 != null) {
                messageDigest.update(byArray3);
            }
            byte[] byArray4 = messageDigest.digest();
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, "RC4");
            Cipher cipher = Cipher.getInstance("RC4");
            cipher.init(2, secretKeySpec);
            byte[] byArray5 = cipher.doFinal(byArray4);
            byte[] byArray6 = new byte[byArray2.length];
            int n = 1;
            while (n <= 19) {
                int n2 = 0;
                while (n2 < byArray2.length) {
                    byArray6[n2] = (byte)(byArray2[n2] ^ n);
                    ++n2;
                }
                secretKeySpec = new SecretKeySpec(byArray6, "RC4");
                cipher.init(2, secretKeySpec);
                byArray5 = cipher.doFinal(byArray5);
                ++n;
            }
            byte[] byArray7 = new byte[32];
            System.arraycopy(byArray5, 0, byArray7, 0, 16);
            System.arraycopy(USER_R3_PADDING, 0, byArray7, 16, 16);
            return byArray7;
        }
        catch (Exception exception) {
            throw new COSSecurityException(exception);
        }
    }

    public int getRevision() {
        return 4;
    }
}

