/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.encoding;

import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.encoding.MacRomanEncoding;
import de.intarsys.pdf.encoding.MappedReader;
import de.intarsys.pdf.encoding.MappedWriter;
import de.intarsys.pdf.encoding.StandardEncoding;
import de.intarsys.pdf.encoding.WinAnsiEncoding;
import de.intarsys.tools.stream.StreamTools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public abstract class Encoding {
    public static final COSName CN_MacRomanEncoding = COSName.constant("MacRomanEncoding");
    public static final COSName CN_StandardEncoding = COSName.constant("StandardEncoding");
    public static final COSName CN_WinAnsiEncoding = COSName.constant("WinAnsiEncoding");
    public static final String NAME_a = "a";
    public static final String NAME_A = "A";
    public static final String NAME_aacute = "aacute";
    public static final String NAME_Aacute = "Aacute";
    public static final String NAME_acircumflex = "acircumflex";
    public static final String NAME_Acircumflex = "Acircumflex";
    public static final String NAME_acute = "acute";
    public static final String NAME_adieresis = "adieresis";
    public static final String NAME_Adieresis = "Adieresis";
    public static final String NAME_ae = "ae";
    public static final String NAME_AE = "AE";
    public static final String NAME_agrave = "agrave";
    public static final String NAME_Agrave = "Agrave";
    public static final String NAME_ampersand = "ampersand";
    public static final String NAME_aring = "aring";
    public static final String NAME_Aring = "Aring";
    public static final String NAME_asciicircum = "asciicircum";
    public static final String NAME_asciitilde = "asciitilde";
    public static final String NAME_asterisk = "asterisk";
    public static final String NAME_at = "at";
    public static final String NAME_atilde = "atilde";
    public static final String NAME_Atilde = "Atilde";
    public static final String NAME_b = "b";
    public static final String NAME_B = "B";
    public static final String NAME_backslash = "backslash";
    public static final String NAME_bar = "bar";
    public static final String NAME_braceleft = "braceleft";
    public static final String NAME_braceright = "braceright";
    public static final String NAME_bracketleft = "bracketleft";
    public static final String NAME_bracketright = "bracketright";
    public static final String NAME_breve = "breve";
    public static final String NAME_brokenbar = "brokenbar";
    public static final String NAME_bullet = "bullet";
    public static final String NAME_c = "c";
    public static final String NAME_C = "C";
    public static final String NAME_caron = "caron";
    public static final String NAME_ccedilla = "ccedilla";
    public static final String NAME_Ccedilla = "Ccedilla";
    public static final String NAME_cedilla = "cedilla";
    public static final String NAME_cent = "cent";
    public static final String NAME_circumflex = "circumflex";
    public static final String NAME_colon = "colon";
    public static final String NAME_comma = "comma";
    public static final String NAME_copyright = "copyright";
    public static final String NAME_currency = "currency";
    public static final String NAME_d = "d";
    public static final String NAME_D = "D";
    public static final String NAME_dagger = "dagger";
    public static final String NAME_daggerdbl = "daggerdbl";
    public static final String NAME_degree = "degree";
    public static final String NAME_dieresis = "dieresis";
    public static final String NAME_divide = "divide";
    public static final String NAME_dollar = "dollar";
    public static final String NAME_dotaccent = "dotaccent";
    public static final String NAME_dotlessi = "dotlessi";
    public static final String NAME_e = "e";
    public static final String NAME_E = "E";
    public static final String NAME_eacute = "eacute";
    public static final String NAME_Eacute = "Eacute";
    public static final String NAME_ecircumflex = "ecircumflex";
    public static final String NAME_Ecircumflex = "Ecircumflex";
    public static final String NAME_edieresis = "edieresis";
    public static final String NAME_Edieresis = "Edieresis";
    public static final String NAME_egrave = "egrave";
    public static final String NAME_Egrave = "Egrave";
    public static final String NAME_eight = "eight";
    public static final String NAME_ellipsis = "ellipsis";
    public static final String NAME_emdash = "emdash";
    public static final String NAME_endash = "endash";
    public static final String NAME_equal = "equal";
    public static final String NAME_eth = "eth";
    public static final String NAME_Eth = "Eth";
    public static final String NAME_Euro = "Euro";
    public static final String NAME_exclam = "exclam";
    public static final String NAME_exclamdown = "exclamdown";
    public static final String NAME_f = "f";
    public static final String NAME_F = "F";
    public static final String NAME_fi = "fi";
    public static final String NAME_five = "five";
    public static final String NAME_fl = "fl";
    public static final String NAME_florin = "florin";
    public static final String NAME_four = "four";
    public static final String NAME_fraction = "fraction";
    public static final String NAME_g = "g";
    public static final String NAME_G = "G";
    public static final String NAME_germandbls = "germandbls";
    public static final String NAME_grave = "grave";
    public static final String NAME_greater = "greater";
    public static final String NAME_guillemotleft = "guillemotleft";
    public static final String NAME_guillemotright = "guillemotright";
    public static final String NAME_guilsinglleft = "guilsinglleft";
    public static final String NAME_guilsinglright = "guilsinglright";
    public static final String NAME_h = "h";
    public static final String NAME_H = "H";
    public static final String NAME_hungarumlaut = "hungarumlaut";
    public static final String NAME_hyphen = "hyphen";
    public static final String NAME_i = "i";
    public static final String NAME_I = "I";
    public static final String NAME_iacute = "iacute";
    public static final String NAME_Iacute = "Iacute";
    public static final String NAME_icircumflex = "icircumflex";
    public static final String NAME_Icircumflex = "Icircumflex";
    public static final String NAME_idieresis = "idieresis";
    public static final String NAME_Idieresis = "Idieresis";
    public static final String NAME_igrave = "igrave";
    public static final String NAME_Igrave = "Igrave";
    public static final String NAME_j = "j";
    public static final String NAME_J = "J";
    public static final String NAME_k = "k";
    public static final String NAME_K = "K";
    public static final String NAME_l = "l";
    public static final String NAME_L = "L";
    public static final String NAME_less = "less";
    public static final String NAME_logicalnot = "logicalnot";
    public static final String NAME_lslash = "lslash";
    public static final String NAME_Lslash = "Lslash";
    public static final String NAME_m = "m";
    public static final String NAME_M = "M";
    public static final String NAME_macron = "macron";
    public static final String NAME_minus = "minus";
    public static final String NAME_mu = "mu";
    public static final String NAME_multiply = "multiply";
    public static final String NAME_n = "n";
    public static final String NAME_N = "N";
    public static final String NAME_nine = "nine";
    public static final String NAME_ntilde = "ntilde";
    public static final String NAME_Ntilde = "Ntilde";
    public static final String NAME_numbersign = "numbersign";
    public static final String NAME_o = "o";
    public static final String NAME_O = "O";
    public static final String NAME_oacute = "oacute";
    public static final String NAME_Oacute = "Oacute";
    public static final String NAME_ocircumflex = "ocircumflex";
    public static final String NAME_Ocircumflex = "Ocircumflex";
    public static final String NAME_odieresis = "odieresis";
    public static final String NAME_Odieresis = "Odieresis";
    public static final String NAME_oe = "oe";
    public static final String NAME_OE = "OE";
    public static final String NAME_ogonek = "ogonek";
    public static final String NAME_ograve = "ograve";
    public static final String NAME_Ograve = "Ograve";
    public static final String NAME_one = "one";
    public static final String NAME_onehalf = "onehalf";
    public static final String NAME_onequarter = "onequarter";
    public static final String NAME_onesuperior = "onesuperior";
    public static final String NAME_ordfeminine = "ordfeminine";
    public static final String NAME_ordmasculine = "ordmasculine";
    public static final String NAME_oslash = "oslash";
    public static final String NAME_Oslash = "Oslash";
    public static final String NAME_otilde = "otilde";
    public static final String NAME_Otilde = "Otilde";
    public static final String NAME_p = "p";
    public static final String NAME_P = "P";
    public static final String NAME_paragraph = "paragraph";
    public static final String NAME_parenleft = "parenleft";
    public static final String NAME_parenright = "parenright";
    public static final String NAME_percent = "percent";
    public static final String NAME_period = "period";
    public static final String NAME_periodcentered = "periodcentered";
    public static final String NAME_perthousand = "perthousand";
    public static final String NAME_plus = "plus";
    public static final String NAME_plusminus = "plusminus";
    public static final String NAME_q = "q";
    public static final String NAME_Q = "Q";
    public static final String NAME_question = "question";
    public static final String NAME_questiondown = "questiondown";
    public static final String NAME_quotedbl = "quotedbl";
    public static final String NAME_quotedblbase = "quotedblbase";
    public static final String NAME_quotedblleft = "quotedblleft";
    public static final String NAME_quotedblright = "quotedblright";
    public static final String NAME_quoteleft = "quoteleft";
    public static final String NAME_quoteright = "quoteright";
    public static final String NAME_quotesinglbase = "quotesinglbase";
    public static final String NAME_quotesingle = "quotesingle";
    public static final String NAME_r = "r";
    public static final String NAME_R = "R";
    public static final String NAME_registered = "registered";
    public static final String NAME_ring = "ring";
    public static final String NAME_s = "s";
    public static final String NAME_S = "S";
    public static final String NAME_scaron = "scaron";
    public static final String NAME_Scaron = "Scaron";
    public static final String NAME_section = "section";
    public static final String NAME_semicolon = "semicolon";
    public static final String NAME_seven = "seven";
    public static final String NAME_six = "six";
    public static final String NAME_slash = "slash";
    public static final String NAME_space = "space";
    public static final String NAME_sterling = "sterling";
    public static final String NAME_t = "t";
    public static final String NAME_T = "T";
    public static final String NAME_thorn = "thorn";
    public static final String NAME_Thorn = "Thorn";
    public static final String NAME_three = "three";
    public static final String NAME_threequarters = "threequarters";
    public static final String NAME_threesuperior = "threesuperior";
    public static final String NAME_tilde = "tilde";
    public static final String NAME_trademark = "trademark";
    public static final String NAME_two = "two";
    public static final String NAME_twosuperior = "twosuperior";
    public static final String NAME_u = "u";
    public static final String NAME_U = "U";
    public static final String NAME_uacute = "uacute";
    public static final String NAME_Uacute = "Uacute";
    public static final String NAME_ucircumflex = "ucircumflex";
    public static final String NAME_Ucircumflex = "Ucircumflex";
    public static final String NAME_udieresis = "udieresis";
    public static final String NAME_Udieresis = "Udieresis";
    public static final String NAME_ugrave = "ugrave";
    public static final String NAME_Ugrave = "Ugrave";
    public static final String NAME_underscore = "underscore";
    public static final String NAME_v = "v";
    public static final String NAME_V = "V";
    public static final String NAME_w = "w";
    public static final String NAME_W = "W";
    public static final String NAME_x = "x";
    public static final String NAME_X = "X";
    public static final String NAME_y = "y";
    public static final String NAME_Y = "Y";
    public static final String NAME_yacute = "yacute";
    public static final String NAME_Yacute = "Yacute";
    public static final String NAME_ydieresis = "ydieresis";
    public static final String NAME_Ydieresis = "Ydieresis";
    public static final String NAME_yen = "yen";
    public static final String NAME_z = "z";
    public static final String NAME_Z = "Z";
    public static final String NAME_zcaron = "zcaron";
    public static final String NAME_Zcaron = "Zcaron";
    public static final String NAME_zero = "zero";

    public static Encoding createNamed(COSName cOSName) {
        if (CN_WinAnsiEncoding.equals(cOSName)) {
            return WinAnsiEncoding.UNIQUE;
        }
        if (CN_MacRomanEncoding.equals(cOSName)) {
            return MacRomanEncoding.UNIQUE;
        }
        if (CN_StandardEncoding.equals(cOSName)) {
            return StandardEncoding.UNIQUE;
        }
        throw new IllegalArgumentException("encoding not supported");
    }

    protected Encoding() {
    }

    public abstract COSObject cosGetObject();

    public Reader createReader(InputStream inputStream) {
        return new MappedReader(inputStream, this);
    }

    public Writer createWriter(OutputStream outputStream) {
        return new MappedWriter(outputStream, this);
    }

    public String decode(byte[] byArray) {
        return this.decode(byArray, 0, byArray.length);
    }

    public String decode(byte[] byArray, int n, int n2) {
        StringWriter stringWriter = new StringWriter();
        this.decode(stringWriter, byArray, n, n2);
        return stringWriter.toString();
    }

    public void decode(Writer writer, byte[] byArray, int n, int n2) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
        Reader reader = this.createReader(byteArrayInputStream);
        try {
            StreamTools.copyEncoded((Reader)reader, (Writer)writer);
        }
        catch (IOException iOException) {}
    }

    public byte[] encode(char[] cArray) {
        return this.encode(cArray, 0, cArray.length);
    }

    public byte[] encode(char[] cArray, int n, int n2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream, cArray, n, n2);
        return byteArrayOutputStream.toByteArray();
    }

    public void encode(OutputStream outputStream, char[] cArray, int n, int n2) {
        Writer writer = this.createWriter(outputStream);
        CharArrayReader charArrayReader = new CharArrayReader(cArray, n, n2);
        try {
            StreamTools.copyEncoded((Reader)charArrayReader, (Writer)writer);
        }
        catch (IOException iOException) {}
    }

    public byte[] encode(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Writer writer = this.createWriter(byteArrayOutputStream);
        StringReader stringReader = new StringReader(string);
        try {
            StreamTools.copyEncoded((Reader)stringReader, (Writer)writer);
        }
        catch (IOException iOException) {}
        return byteArrayOutputStream.toByteArray();
    }

    public abstract int getDecoded(int var1);

    public int getDifferenceDecoded(int n) {
        return n;
    }

    public String getDifferenceGlyphName(int n) {
        return null;
    }

    public abstract int getEncoded(int var1);

    public abstract int getEncoded(String var1);

    public abstract String getGlyphName(int var1);

    public abstract String getName();

    public int getNextDecoded(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            return -1;
        }
        return this.getDecoded(n & 0xFF);
    }

    public int getNextEncoded(InputStream inputStream) throws IOException {
        return inputStream.read();
    }

    public abstract int getValidEncoded(int var1);

    public abstract int getValidEncoded(String var1);

    public boolean isEncodable(char[] cArray) {
        return this.isEncodable(cArray, 0, cArray.length);
    }

    public boolean isEncodable(char[] cArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            if (this.getEncoded(cArray[n3]) == -1) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public boolean isEncodable(String string) {
        char[] cArray = string.toCharArray();
        return this.isEncodable(cArray);
    }

    public boolean isFontSpecificEncoding() {
        return false;
    }

    public void putNextDecoded(OutputStream outputStream, int n) throws IOException {
        outputStream.write(this.getValidEncoded(n));
    }

    public void putNextEncoded(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n);
    }

    public String toString() {
        return this.getName();
    }
}

