/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.encoding.Encoding;
import de.intarsys.pdf.encoding.MacOSRomanEncoding;
import de.intarsys.pdf.encoding.StandardEncoding;
import de.intarsys.pdf.font.CIDFontType0;
import de.intarsys.pdf.font.CIDFontType2;
import de.intarsys.pdf.font.CMap;
import de.intarsys.pdf.font.DifferenceEncoding;
import de.intarsys.pdf.font.IdentityCMap;
import de.intarsys.pdf.font.PDFontDescriptor;
import de.intarsys.pdf.font.PDFontDescriptorEmbedded;
import de.intarsys.pdf.font.PDFontMMType1;
import de.intarsys.pdf.font.PDFontStyle;
import de.intarsys.pdf.font.PDFontTrueType;
import de.intarsys.pdf.font.PDFontType0;
import de.intarsys.pdf.font.PDFontType1;
import de.intarsys.pdf.font.PDFontType3;
import de.intarsys.pdf.font.PDGlyphs;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.tools.stream.StreamTools;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;

public abstract class PDFont
extends PDObject {
    public static final COSName CN_Subtype_CIDFontType0 = COSName.constant("CIDFontType0");
    public static final COSName CN_Subtype_CIDFontType2 = COSName.constant("CIDFontType2");
    public static final COSName CN_Subtype_MMType1 = COSName.constant("MMType1");
    public static final COSName CN_Subtype_TrueType = COSName.constant("TrueType");
    public static final COSName CN_Subtype_Type0 = COSName.constant("Type0");
    public static final COSName CN_Subtype_Type1 = COSName.constant("Type1");
    public static final COSName CN_Subtype_Type3 = COSName.constant("Type3");
    public static final COSName CN_Type_Font = COSName.constant("Font");
    public static final COSName DK_BaseFont = COSName.constant("BaseFont");
    public static final COSName DK_Encoding = COSName.constant("Encoding");
    public static final COSName DK_FirstChar = COSName.constant("FirstChar");
    public static final COSName DK_FontDescriptor = COSName.constant("FontDescriptor");
    public static final COSName DK_LastChar = COSName.constant("LastChar");
    public static final COSName DK_ToUnicode = COSName.constant("ToUnicode");
    public static final COSName DK_Widths = COSName.constant("Widths");
    public static final COSName DK_Name = COSName.constant("Name");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private static CMap UNDEFINED = new IdentityCMap();
    private Encoding cachedEncoding;
    private PDFontDescriptor cachedFontDescriptor;
    private CMap cachedToUnicode = UNDEFINED;

    public static String getFontFamilyName(String string) {
        int n;
        int n2;
        if (string == null) {
            return null;
        }
        int n3 = string.indexOf(43);
        if (n3 > 0) {
            string = string.substring(n3 + 1);
        }
        if ((n2 = string.lastIndexOf(45)) > 0) {
            string = string.substring(0, n2);
        }
        if ((n = string.indexOf(44)) > 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    public static String getFontName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(43);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public static PDFontStyle getFontStyle(String string) {
        int n;
        if (string == null) {
            return PDFontStyle.REGULAR;
        }
        int n2 = string.lastIndexOf(45);
        if (n2 > 0) {
            string = string.substring(n2 + 1);
        }
        if ((n = string.indexOf(44)) > 0) {
            string = string.substring(n + 1).trim();
        }
        return PDFontStyle.getFontStyle(string);
    }

    protected PDFont(COSObject cOSObject) {
        super(cOSObject);
    }

    protected COSName cosGetExpectedType() {
        return CN_Type_Font;
    }

    protected PDFontDescriptor createBuiltinFontDescriptor() {
        return null;
    }

    protected int[] createBuiltInWidths(int[] nArray) {
        return nArray;
    }

    protected int[] createDeclaredWidths(int[] nArray, COSArray cOSArray) {
        int n = this.getFirstChar();
        Iterator iterator = cOSArray.iterator();
        while (iterator.hasNext()) {
            COSNumber cOSNumber = ((COSObject)iterator.next()).asNumber();
            if (cOSNumber != null) {
                nArray[n] = cOSNumber.intValue();
            }
            ++n;
        }
        return nArray;
    }

    protected Encoding createDefaultEncoding() {
        return StandardEncoding.UNIQUE;
    }

    protected Encoding createEncoding() {
        COSObject cOSObject = this.cosGetField(DK_Encoding);
        if (cOSObject.isNull()) {
            return this.createDefaultEncoding();
        }
        if (cOSObject instanceof COSName) {
            return Encoding.createNamed((COSName)cOSObject);
        }
        if (cOSObject instanceof COSDictionary) {
            return DifferenceEncoding.create((COSDictionary)cOSObject, this);
        }
        throw new IllegalArgumentException("encoding not supported");
    }

    protected int createFirstChar() {
        return 0;
    }

    protected PDFontDescriptor createFontDescriptor() {
        COSObject cOSObject = this.cosGetField(DK_FontDescriptor);
        if (cOSObject.isNull()) {
            return this.createBuiltinFontDescriptor();
        }
        return (PDFontDescriptorEmbedded)PDFontDescriptorEmbedded.META.createFromCos(cOSObject);
    }

    protected int createLastChar() {
        return 255;
    }

    protected int[] createWidths() {
        int[] nArray = new int[256];
        int n = this.getMissingWidth();
        int n2 = 0;
        while (n2 < 256) {
            nArray[n2] = n;
            ++n2;
        }
        COSArray cOSArray = this.cosGetField(DK_Widths).asArray();
        if (cOSArray == null) {
            return this.createBuiltInWidths(nArray);
        }
        return this.createDeclaredWidths(nArray, cOSArray);
    }

    public void dumpFontFile(File file) {
        block9: {
            PDFontDescriptorEmbedded pDFontDescriptorEmbedded = (PDFontDescriptorEmbedded)this.getFontDescriptor();
            if (pDFontDescriptorEmbedded == null) {
                return;
            }
            byte[] byArray = pDFontDescriptorEmbedded.getFontFile();
            if (byArray == null) {
                byArray = pDFontDescriptorEmbedded.getFontFile2();
            }
            if (byArray == null) {
                byArray = pDFontDescriptorEmbedded.getFontFile3();
            }
            if (byArray == null) {
                return;
            }
            FileOutputStream fileOutputStream = null;
            try {
                try {
                    fileOutputStream = new FileOutputStream(file);
                    fileOutputStream.write(byArray);
                }
                catch (Exception exception) {
                    StreamTools.close(fileOutputStream);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                StreamTools.close(fileOutputStream);
                throw throwable;
            }
            StreamTools.close((OutputStream)fileOutputStream);
        }
    }

    public COSName getBaseFont() {
        return this.cosGetField(DK_BaseFont).asName();
    }

    public Encoding getEncoding() {
        if (this.cachedEncoding == null) {
            this.cachedEncoding = this.createEncoding();
        }
        return this.cachedEncoding;
    }

    public int getFirstChar() {
        COSInteger cOSInteger = this.cosGetField(DK_FirstChar).asInteger();
        if (cOSInteger == null) {
            return this.createFirstChar();
        }
        return ((COSNumber)cOSInteger).intValue();
    }

    public PDFontDescriptor getFontDescriptor() {
        if (this.cachedFontDescriptor == null) {
            this.cachedFontDescriptor = this.createFontDescriptor();
        }
        return this.cachedFontDescriptor;
    }

    public String getFontFamilyName() {
        try {
            String string;
            PDFontDescriptor pDFontDescriptor = this.getFontDescriptor();
            if (pDFontDescriptor != null && (string = pDFontDescriptor.getFontFamily()) != null) {
                return string;
            }
        }
        catch (RuntimeException runtimeException) {}
        return PDFontTrueType.getFontFamilyName(this.getBaseFont().stringValue());
    }

    public String getFontName() {
        return this.getBaseFont().stringValue();
    }

    public String getFontNameNormalized() {
        return PDFont.getFontName(this.getFontName());
    }

    public PDFontStyle getFontStyle() {
        return PDFont.getFontStyle(this.getBaseFont().stringValue());
    }

    public abstract String getFontType();

    public abstract PDGlyphs getGlyphsEncoded(int var1);

    public abstract int getGlyphWidthEncoded(int var1);

    public int getLastChar() {
        COSInteger cOSInteger = this.cosGetField(DK_LastChar).asInteger();
        if (cOSInteger == null) {
            return this.createLastChar();
        }
        return ((COSNumber)cOSInteger).intValue();
    }

    public int getMacintoshRomanCode(int n) {
        String string = this.getEncoding().getGlyphName(n);
        return MacOSRomanEncoding.UNIQUE.getEncoded(string);
    }

    public int getMissingWidth() {
        if (this.getFontDescriptor() == null) {
            return 0;
        }
        return this.getFontDescriptor().getMissingWidth();
    }

    public abstract PDGlyphs getNextGlyphsEncoded(ByteArrayInputStream var1) throws IOException;

    public CMap getToUnicode() {
        if (this.cachedToUnicode == UNDEFINED) {
            this.cachedToUnicode = (CMap)CMap.META.createFromCos(this.cosGetField(DK_ToUnicode));
        }
        return this.cachedToUnicode;
    }

    public void invalidateCaches() {
        super.invalidateCaches();
        this.cachedEncoding = null;
        this.cachedFontDescriptor = null;
        this.cachedToUnicode = UNDEFINED;
    }

    public boolean isEmbedded() {
        COSObject cOSObject = this.cosGetField(DK_FontDescriptor);
        if (cOSObject.isNull() && !(this instanceof PDFontType0)) {
            return false;
        }
        if (this.getFontDescriptor() == null) {
            return false;
        }
        if (this.getFontDescriptor().getFontFile() != null) {
            return true;
        }
        if (this.getFontDescriptor().getFontFile2() != null) {
            return true;
        }
        return this.getFontDescriptor().getFontFile3() != null;
    }

    public boolean isStandardFont() {
        return false;
    }

    public boolean isSubset() {
        byte[] byArray = this.getBaseFont().byteValue();
        if (byArray.length > 7) {
            return byArray[6] == 43;
        }
        if (this.getFirstChar() > 32) {
            return true;
        }
        return this.getLastChar() < 128;
    }

    public void setBaseFont(String string) {
        this.setFieldName(DK_BaseFont, string);
    }

    public void setEncoding(Encoding encoding) {
        this.cachedEncoding = encoding;
        if (encoding != null) {
            COSObject cOSObject = this.cachedEncoding.cosGetObject();
            if (cOSObject == null || cOSObject.isNull()) {
                this.cosRemoveField(DK_Encoding);
            } else {
                this.cosSetField(DK_Encoding, cOSObject);
            }
        } else {
            this.cosRemoveField(DK_Encoding);
        }
    }

    public void setFontDescriptor(PDFontDescriptor pDFontDescriptor) {
        this.cachedFontDescriptor = pDFontDescriptor;
        this.setFieldObject(DK_FontDescriptor, this.cachedFontDescriptor);
    }

    public void setToUnicode(CMap cMap) {
        this.cachedToUnicode = UNDEFINED;
        this.setFieldObject(DK_ToUnicode, cMap);
    }

    public String toString() {
        return String.valueOf(this.cosGetSubtype().stringValue()) + "-Font " + this.getBaseFont().toString() + " (" + this.getEncoding() + ")";
    }

    public static class MetaClass
    extends PDObject.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }

        protected COSBasedObject.MetaClass doDetermineClass(COSObject cOSObject) {
            COSDictionary cOSDictionary = cOSObject.asDictionary();
            if (cOSDictionary == null) {
                throw new IllegalArgumentException("font object is not a COSDictionary as required");
            }
            COSName cOSName = cOSDictionary.get(DK_Type).asName();
            if (cOSName == null) {
                throw new IllegalArgumentException("Dictionary has no type");
            }
            if (!cOSName.equals(CN_Type_Font)) {
                throw new IllegalArgumentException("type <" + cOSName + "> is not a valid font type");
            }
            COSName cOSName2 = cOSDictionary.get(DK_Subtype).asName();
            if (cOSName2 == null) {
                throw new IllegalArgumentException("font not identified by subtype");
            }
            if (cOSName2.equals(CN_Subtype_Type1)) {
                return PDFontType1.META;
            }
            if (cOSName2.equals(CN_Subtype_TrueType)) {
                if (cOSDictionary.get(DK_FontDescriptor).isNull()) {
                    return PDFontType1.META;
                }
                return PDFontTrueType.META;
            }
            if (cOSName2.equals(CN_Subtype_MMType1)) {
                return PDFontMMType1.META;
            }
            if (cOSName2.equals(CN_Subtype_Type0)) {
                return PDFontType0.META;
            }
            if (cOSName2.equals(CN_Subtype_Type3)) {
                return PDFontType3.META;
            }
            if (cOSName2.equals(CN_Subtype_CIDFontType0)) {
                return CIDFontType0.META;
            }
            if (cOSName2.equals(CN_Subtype_CIDFontType2)) {
                return CIDFontType2.META;
            }
            throw new IllegalArgumentException("font subtype <" + cOSName2 + "> not supported");
        }

        public Class getRootClass() {
            return PDFont.class;
        }
    }
}

