/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDGlyphs;
import java.io.ByteArrayInputStream;
import java.util.Arrays;

public abstract class PDSingleByteFont
extends PDFont {
    private PDGlyphs[] cachedGlyphs = new PDGlyphs[256];
    private int[] cachedWidths;

    public PDSingleByteFont(COSObject cOSObject) {
        super(cOSObject);
    }

    public PDGlyphs getGlyphsEncoded(int n) {
        PDGlyphs pDGlyphs = this.cachedGlyphs[n];
        if (pDGlyphs == null) {
            this.cachedGlyphs[n] = pDGlyphs = new PDGlyphs(this, n);
        }
        return pDGlyphs;
    }

    public int getGlyphWidthEncoded(int n) {
        if (this.cachedWidths == null) {
            this.cachedWidths = this.createWidths();
        }
        if (n < 0 || n > this.cachedWidths.length) {
            return this.getMissingWidth();
        }
        return this.cachedWidths[n];
    }

    public int[] getGlyphWidths() {
        if (this.cachedWidths == null) {
            this.cachedWidths = this.createWidths();
        }
        return this.cachedWidths;
    }

    public PDGlyphs getNextGlyphsEncoded(ByteArrayInputStream byteArrayInputStream) {
        int n = byteArrayInputStream.read();
        if (n == -1) {
            return null;
        }
        return this.getGlyphsEncoded(n);
    }

    public void invalidateCaches() {
        super.invalidateCaches();
        this.cachedWidths = null;
        Arrays.fill(this.cachedGlyphs, null);
    }
}

