/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font.outlet;

import de.intarsys.pdf.font.outlet.IFontFactory;
import de.intarsys.pdf.font.outlet.NullFontFactory;
import java.util.Iterator;
import sun.misc.Service;

public class FontFactory {
    private static boolean lookupProviders = true;
    private static IFontFactory Unique;

    protected static IFontFactory findProviders() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = IFontFactory.class.getClassLoader();
        }
        Iterator iterator = Service.providers(IFontFactory.class, (ClassLoader)classLoader);
        while (iterator.hasNext()) {
            try {
                return (IFontFactory)iterator.next();
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    public static IFontFactory get() {
        if (Unique == null) {
            FontFactory.init();
        }
        return Unique;
    }

    protected static void init() {
        if (lookupProviders) {
            Unique = FontFactory.findProviders();
        }
        if (Unique == null) {
            Unique = new NullFontFactory();
        }
    }

    public static boolean isLookupProviders() {
        return lookupProviders;
    }

    public static void set(IFontFactory iFontFactory) {
        Unique = iFontFactory;
    }

    public static void setLookupProviders(boolean bl) {
        lookupProviders = bl;
    }
}

