/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font.outlet;

import de.intarsys.pdf.encoding.Encoding;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontStyle;
import de.intarsys.pdf.font.outlet.IFontQuery;

public class FontQuery
implements IFontQuery {
    private PDFont baseFont;
    private PDFontStyle overrideFontStyle = PDFontStyle.UNDEFINED;
    private String overrideFontType = null;
    private String overrideFontFamilyName;
    private String overrideFontName;
    private Encoding overrideEncoding;

    public FontQuery() {
    }

    public FontQuery(PDFont pDFont) {
        this.baseFont = pDFont;
    }

    public FontQuery(String string) {
        this.setOverrideFontName(string);
    }

    public FontQuery(String string, PDFontStyle pDFontStyle) {
        this.setOverrideFontFamilyName(string);
        this.setOverrideFontStyle(pDFontStyle);
    }

    public FontQuery(String string, String string2) {
        this.setOverrideFontFamilyName(string);
        this.setOverrideFontStyle(PDFontStyle.getFontStyle(string2));
    }

    protected boolean checkLastChar() {
        return this.getBaseFont() != null;
    }

    protected PDFont getBaseFont() {
        return this.baseFont;
    }

    public Encoding getEncoding() {
        if (this.getOverrideEncoding() == null) {
            if (this.getBaseFont() == null) {
                return null;
            }
            return this.getBaseFont().getEncoding();
        }
        return this.getOverrideEncoding();
    }

    public String getFontFamilyName() {
        if (this.getOverrideFontFamilyName() == null) {
            if (this.getBaseFont() == null) {
                return null;
            }
            return this.getBaseFont().getFontFamilyName();
        }
        return this.getOverrideFontFamilyName();
    }

    public String getFontName() {
        if (this.getOverrideFontName() == null) {
            if (this.getBaseFont() == null || this.getOverrideFontFamilyName() == null || this.getOverrideFontStyle() == null) {
                return null;
            }
            return this.getBaseFont().getFontNameNormalized();
        }
        return this.getOverrideFontName();
    }

    public PDFontStyle getFontStyle() {
        if (this.getOverrideFontStyle() == PDFontStyle.UNDEFINED) {
            if (this.getBaseFont() == null) {
                return PDFontStyle.UNDEFINED;
            }
            return this.getBaseFont().getFontStyle();
        }
        return this.getOverrideFontStyle();
    }

    public String getFontType() {
        if (this.getOverrideFontType() == null) {
            if (this.getBaseFont() == null) {
                return null;
            }
            return this.getBaseFont().getFontType();
        }
        return this.getOverrideFontType();
    }

    public Encoding getOverrideEncoding() {
        return this.overrideEncoding;
    }

    public String getOverrideFontFamilyName() {
        return this.overrideFontFamilyName;
    }

    public String getOverrideFontName() {
        return this.overrideFontName;
    }

    public PDFontStyle getOverrideFontStyle() {
        return this.overrideFontStyle;
    }

    public String getOverrideFontType() {
        return this.overrideFontType;
    }

    public void setOverrideEncoding(Encoding encoding) {
        this.overrideEncoding = encoding;
    }

    public void setOverrideFontFamilyName(String string) {
        this.overrideFontFamilyName = string;
    }

    public void setOverrideFontName(String string) {
        this.overrideFontName = string;
    }

    public void setOverrideFontStyle(PDFontStyle pDFontStyle) {
        this.overrideFontStyle = pDFontStyle;
    }

    public void setOverrideFontType(String string) {
        this.overrideFontType = string;
    }
}

