/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.parser;

import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.CSOperation;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.parser.COSLoadError;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.parser.PDFParser;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessByteArray;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;

public class CSContentParser
extends PDFParser {
    private static final COSObject[] EMPTY_OPERANDS = new COSObject[0];
    private Object[] operands = new Object[10];
    private int size = 0;

    protected static boolean accepts(CSOperation cSOperation) {
        byte[] byArray = cSOperation.getOperatorToken();
        switch (byArray[0]) {
            case 113: {
                return byArray.length == 1;
            }
            case 81: {
                return byArray.length == 1;
            }
            case 84: {
                switch (byArray[1]) {
                    case 106: {
                        return byArray.length == 2;
                    }
                    case 74: {
                        return byArray.length == 2;
                    }
                    case 102: {
                        return byArray.length == 2;
                    }
                    case 100: {
                        return byArray.length == 2;
                    }
                    case 76: {
                        return byArray.length == 2;
                    }
                    case 68: {
                        return byArray.length == 2;
                    }
                    case 99: {
                        return byArray.length == 2;
                    }
                    case 109: {
                        return byArray.length == 2;
                    }
                    case 114: {
                        return byArray.length == 2;
                    }
                    case 115: {
                        return byArray.length == 2;
                    }
                    case 119: {
                        return byArray.length == 2;
                    }
                    case 122: {
                        return byArray.length == 2;
                    }
                    case 42: {
                        return byArray.length == 2;
                    }
                }
                break;
            }
            case 110: {
                return byArray.length == 1;
            }
            case 115: {
                if (byArray.length == 1) {
                    return true;
                }
                switch (byArray[1]) {
                    case 99: {
                        if (byArray.length == 2) {
                            return true;
                        }
                        return byArray.length == 3;
                    }
                    case 104: {
                        return byArray.length == 2;
                    }
                }
                break;
            }
            case 103: {
                if (byArray.length == 1) {
                    return true;
                }
                return byArray.length == 2;
            }
            case 114: {
                switch (byArray[1]) {
                    case 101: {
                        return byArray.length == 2;
                    }
                    case 103: {
                        return byArray.length == 2;
                    }
                    case 105: {
                        return byArray.length == 2;
                    }
                }
                break;
            }
            case 82: {
                return byArray.length == 2;
            }
            case 109: {
                return byArray.length == 1;
            }
            case 108: {
                return byArray.length == 1;
            }
            case 102: {
                if (byArray.length == 1) {
                    return true;
                }
                return byArray.length == 2;
            }
            case 66: {
                if (byArray.length == 1) {
                    return true;
                }
                switch (byArray[1]) {
                    case 42: {
                        return byArray.length == 2;
                    }
                    case 84: {
                        return byArray.length == 2;
                    }
                    case 77: {
                        return byArray.length == 3;
                    }
                    case 68: {
                        return byArray.length == 3;
                    }
                    case 73: {
                        return byArray.length == 2;
                    }
                    case 88: {
                        return byArray.length == 2;
                    }
                }
                break;
            }
            case 98: {
                if (byArray.length == 1) {
                    return true;
                }
                return byArray.length == 2;
            }
            case 83: {
                if (byArray.length == 1) {
                    return true;
                }
                if (byArray.length == 2) {
                    return true;
                }
                return byArray.length == 3;
            }
            case 104: {
                return byArray.length == 1;
            }
            case 87: {
                if (byArray.length == 1) {
                    return true;
                }
                return byArray.length == 2;
            }
            case 99: {
                if (byArray.length == 1) {
                    return true;
                }
                switch (byArray[1]) {
                    case 109: {
                        return byArray.length == 2;
                    }
                    case 115: {
                        return byArray.length == 2;
                    }
                }
                break;
            }
            case 69: {
                switch (byArray[1]) {
                    case 84: {
                        return byArray.length == 2;
                    }
                    case 77: {
                        return byArray.length == 3;
                    }
                    case 73: {
                        return byArray.length == 2;
                    }
                    case 88: {
                        return byArray.length == 2;
                    }
                }
                break;
            }
            case 71: {
                return byArray.length == 1;
            }
            case 39: {
                return byArray.length == 1;
            }
            case 34: {
                return byArray.length == 1;
            }
            case 67: {
                return byArray.length == 2;
            }
            case 100: {
                if (byArray.length == 1) {
                    return true;
                }
                switch (byArray[1]) {
                    case 48: {
                        return byArray.length == 2;
                    }
                    case 49: {
                        return byArray.length == 2;
                    }
                }
                break;
            }
            case 68: {
                switch (byArray[1]) {
                    case 111: {
                        return byArray.length == 2;
                    }
                    case 80: {
                        return byArray.length == 2;
                    }
                }
                break;
            }
            case 70: {
                return byArray.length == 1;
            }
            case 105: {
                return byArray.length == 1;
            }
            case 73: {
                return byArray.length == 2;
            }
            case 106: {
                return byArray.length == 1;
            }
            case 74: {
                return byArray.length == 1;
            }
            case 75: {
                return byArray.length == 1;
            }
            case 107: {
                return byArray.length == 1;
            }
            case 77: {
                if (byArray.length == 1) {
                    return true;
                }
                return byArray.length == 2;
            }
            case 118: {
                return byArray.length == 1;
            }
            case 119: {
                return byArray.length == 1;
            }
            case 121: {
                return byArray.length == 1;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    protected COSIndirectObject createObjectReference(IRandomAccess iRandomAccess) throws IOException, COSLoadException {
        COSLoadError cOSLoadError = new COSLoadError("indirect objects not allowed in streams at character index " + iRandomAccess.getOffset());
        this.handleError(cOSLoadError);
        return null;
    }

    protected void parseImageData(IRandomAccess iRandomAccess, COSStream cOSStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = iRandomAccess.read();
        while (n != -1) {
            block9: {
                if (n == 10 || n == 32) {
                    long l;
                    block7: {
                        block8: {
                            l = iRandomAccess.getOffset();
                            int n2 = iRandomAccess.read();
                            if (n2 != 69 || (n2 = iRandomAccess.read()) != 73) break block7;
                            CSOperation cSOperation = this.parseOperation(iRandomAccess);
                            if (cSOperation != null && !CSContentParser.accepts(cSOperation)) break block8;
                            iRandomAccess.seek(l);
                            break;
                        }
                        try {
                            try {
                                this.toString();
                            }
                            catch (Exception exception) {
                                iRandomAccess.seek(l);
                                break block9;
                            }
                        }
                        catch (Throwable throwable) {
                            iRandomAccess.seek(l);
                            throw throwable;
                        }
                    }
                    iRandomAccess.seek(l);
                }
            }
            byteArrayOutputStream.write(n);
            n = iRandomAccess.read();
        }
        cOSStream.setEncodedBytes(byteArrayOutputStream.toByteArray());
    }

    protected CSOperation parseOperation(IRandomAccess iRandomAccess) throws IOException, COSLoadException {
        while (true) {
            Object[] objectArray;
            Object object;
            if ((object = this.parseElement(iRandomAccess)) instanceof byte[]) {
                if (this.size == 0) {
                    objectArray = EMPTY_OPERANDS;
                } else {
                    objectArray = new COSObject[this.size];
                    System.arraycopy(this.operands, 0, objectArray, 0, this.size);
                }
                this.size = 0;
                return new CSOperation((byte[])object, (COSObject[])objectArray);
            }
            if (object == null) {
                int n = iRandomAccess.read();
                if (n != -1) {
                    iRandomAccess.seekBy(-1L);
                    COSLoadError cOSLoadError = new COSLoadError("unexpected char (" + (char)n + ") at character index " + iRandomAccess.getOffset());
                    this.handleError(cOSLoadError);
                }
                this.size = 0;
                return null;
            }
            if (this.size >= this.operands.length) {
                objectArray = new Object[this.size << 2];
                System.arraycopy(this.operands, 0, objectArray, 0, this.size);
                this.operands = objectArray;
            }
            this.operands[this.size++] = object;
        }
    }

    protected CSOperation parseOperationEI(IRandomAccess iRandomAccess, COSDictionary cOSDictionary) throws IOException, COSLoadException {
        COSObject[] cOSObjectArray;
        COSStream cOSStream = COSStream.create(cOSDictionary);
        this.parseImageData(iRandomAccess, cOSStream);
        this.operands[this.size++] = cOSStream;
        Object object = this.parseElement(iRandomAccess);
        if (!(object instanceof byte[])) {
            cOSObjectArray = new COSLoadError("EI expected at character index " + iRandomAccess.getOffset());
            this.handleError((COSLoadError)cOSObjectArray);
        }
        cOSObjectArray = new COSObject[this.size];
        System.arraycopy(this.operands, 0, cOSObjectArray, 0, this.size);
        CSOperation cSOperation = new CSOperation((byte[])object, cOSObjectArray);
        this.size = 0;
        return cSOperation;
    }

    public CSContent parseStream(byte[] byArray) throws IOException, COSLoadException {
        return this.parseStream((IRandomAccess)new RandomAccessByteArray(byArray));
    }

    public CSContent parseStream(IRandomAccess iRandomAccess) throws IOException, COSLoadException {
        CSContent cSContent = CSContent.createNew();
        CSOperation cSOperation;
        while ((cSOperation = this.parseOperation(iRandomAccess)) != null) {
            byte[] byArray = cSOperation.getOperatorToken();
            if (byArray.length == 2 && byArray[0] == 73 && byArray[1] == 68) {
                COSDictionary cOSDictionary = COSDictionary.create();
                Iterator iterator = cSOperation.getOperands();
                while (iterator.hasNext()) {
                    cOSDictionary.put(((COSObject)iterator.next()).asName(), ((COSObject)iterator.next()).copyShallow());
                }
                cSOperation = this.parseOperationEI(iRandomAccess, cOSDictionary);
                if (cSOperation == null) continue;
                cSContent.addOperation(cSOperation);
                continue;
            }
            cSContent.addOperation(cSOperation);
        }
        return cSContent;
    }
}

