/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import java.util.HashSet;
import java.util.Set;

public class PDAFButtonField
extends PDAcroFormField {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName DK_Opt = COSName.constant("Opt");

    protected PDAFButtonField(COSObject cOSObject) {
        super(cOSObject);
    }

    public boolean isCheckbox() {
        return !this.isPushbutton() && !this.isRadio();
    }

    public COSName cosGetExpectedFieldType() {
        return CN_FT_Btn;
    }

    public void setPushbutton(boolean bl) {
        this.getFieldFlags().setPushbutton(bl);
    }

    public boolean isPushbutton() {
        return this.getFieldFlags().isPushbutton();
    }

    public boolean isRadio() {
        return this.getFieldFlags().isRadio();
    }

    public boolean isTypeBtn() {
        return true;
    }

    public COSObject cosSetValue(COSObject cOSObject) {
        if (this.isCheckbox() || this.isRadio()) {
            COSName cOSName = cOSObject instanceof COSName ? (COSName)cOSObject : (cOSObject == null ? PDWidgetAnnotation.CN_State_Off : COSName.create(cOSObject.stringValue()));
            for (PDWidgetAnnotation pDWidgetAnnotation : this.getAnnotations()) {
                Set set = pDWidgetAnnotation.getAppearanceStates();
                if (set.contains(cOSName)) {
                    pDWidgetAnnotation.setAppearanceState((COSName)cOSName.copyOptional());
                    continue;
                }
                pDWidgetAnnotation.setAppearanceState(PDWidgetAnnotation.CN_State_Off);
            }
            return super.cosSetValue(cOSName);
        }
        return COSNull.NULL;
    }

    public void setValueString(String string) {
        if (string == null) {
            super.setValueString(string);
        }
        if (this.isCheckbox() || this.isRadio()) {
            COSName cOSName = COSName.create(string);
            this.cosSetValue(cOSName);
        }
    }

    protected COSName setButtonAppearanceState(PDAnnotation pDAnnotation, String string) {
        COSName cOSName = COSName.create(string);
        Set set = pDAnnotation.getAppearanceStates();
        if (!set.contains(cOSName)) {
            COSName cOSName2;
            cOSName = cOSName2 = COSName.create("Off");
            if ((string = string.toLowerCase().trim()).equals("1") || string.startsWith("t") || string.startsWith("y") || string.startsWith("w") || string.startsWith("j") || string.startsWith("x")) {
                for (COSName cOSName3 : set) {
                    if (cOSName3.equals(cOSName2)) continue;
                    cOSName = (COSName)cOSName3.copyOptional();
                    break;
                }
            }
        }
        pDAnnotation.setAppearanceState(cOSName);
        return cOSName;
    }

    public Set getAvailableButtonAppearanceStates() {
        HashSet hashSet = new HashSet();
        for (PDAnnotation pDAnnotation : this.getAnnotations()) {
            hashSet.addAll(pDAnnotation.getAppearanceStates());
        }
        return hashSet;
    }

    public Set getAvailableButtonAppearanceStatesNoOff() {
        Set set = this.getAvailableButtonAppearanceStates();
        COSName cOSName = COSName.create("Off");
        set.remove(cOSName);
        return set;
    }

    public void reset() {
        COSObject cOSObject = this.cosGetDefaultValue();
        cOSObject = cOSObject.isNull() ? COSString.create("") : cOSObject.copyOptional();
        this.cosSetValue(cOSObject);
    }

    public boolean isChecked() {
        if (this.isCheckbox()) {
            return !PDWidgetAnnotation.CN_State_Off.equals(this.getAnyAnnotation().getAppearanceState());
        }
        return false;
    }

    public static class MetaClass
    extends PDAcroFormField.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }

        protected COSBasedObject doCreateCOSBasedObject(COSObject cOSObject) {
            return new PDAFButtonField(cOSObject);
        }
    }
}

