/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDPattern;
import de.intarsys.pdf.pd.PDResources;

public class PDTilingPattern
extends PDPattern {
    private static final COSName DK_BBox = COSName.constant("BBox");
    private static final COSName DK_Resources = COSName.constant("Resources");
    private static final COSName DK_XStep = COSName.constant("XStep");
    private static final COSName DK_YStep = COSName.constant("YStep");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private CSContent cachedContent;
    private float xStep;
    private float yStep;

    protected PDTilingPattern(COSObject cOSObject) {
        super(cOSObject);
        COSNumber cOSNumber = this.cosGetField(DK_XStep).asNumber();
        this.xStep = cOSNumber.floatValue();
        COSNumber cOSNumber2 = this.cosGetField(DK_YStep).asNumber();
        this.yStep = cOSNumber2.floatValue();
    }

    public COSDictionary cosGetDict() {
        return this.cosGetStream().getDict();
    }

    public CDSRectangle getBoundingBox() {
        COSArray cOSArray = this.cosGetField(DK_BBox).asArray();
        if (cOSArray == null) {
            return null;
        }
        return CDSRectangle.createFromCOS(cOSArray);
    }

    public CSContent getContentStream() {
        if (this.cachedContent == null) {
            this.cachedContent = CSContent.createFromCos(this.cosGetStream());
        }
        return this.cachedContent;
    }

    public int getPatternType() {
        return 1;
    }

    public PDResources getResources() {
        COSDictionary cOSDictionary = this.cosGetField(DK_Resources).asDictionary();
        return (PDResources)PDResources.META.createFromCos(cOSDictionary);
    }

    public float getXStep() {
        return this.xStep;
    }

    public float getYStep() {
        return this.yStep;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MetaClass
    extends PDPattern.MetaClass {
        protected MetaClass(Class<?> clazz) {
            super(clazz);
        }
    }
}

