/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.pd.PDObject;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDTransformParams
extends PDObject {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName CN_Type_TransformParams = COSName.constant("TransformParams");
    public static final COSName DK_P = COSName.constant("P");
    public static final COSName DK_V = COSName.constant("V");
    public static final COSName DK_Action = COSName.constant("Action");
    public static final COSName DK_Fields = COSName.constant("Fields");
    public static final COSName CN_All = COSName.constant("All");
    public static final COSName CN_Include = COSName.constant("Include");
    public static final COSName CN_Exclude = COSName.constant("Exclude");
    public static final COSName CN_Version_1_2 = COSName.constant("1.2");

    protected PDTransformParams(COSObject cOSObject) {
        super(cOSObject);
    }

    public COSName cosGetAction() {
        return this.cosGetField(DK_Action).asName();
    }

    @Override
    protected COSName cosGetExpectedType() {
        return CN_Type_TransformParams;
    }

    public COSArray cosGetFields() {
        return this.cosGetField(DK_Fields).asArray();
    }

    public void cosSetAction(COSName cOSName) {
        this.cosSetField(DK_Action, cOSName);
    }

    public void cosSetFields(COSArray cOSArray) {
        this.cosSetField(DK_Fields, cOSArray);
    }

    public List<String> getFields() {
        ArrayList<String> arrayList = new ArrayList<String>();
        COSArray cOSArray = this.cosGetFields();
        if (cOSArray != null) {
            int n = 0;
            while (n < cOSArray.size()) {
                COSString cOSString = cOSArray.get(n).asString();
                arrayList.add(cOSString.stringValue());
                ++n;
            }
        }
        return arrayList;
    }

    public int getPermissions() {
        return this.getFieldInt(DK_P, 2);
    }

    @Override
    protected void initializeFromScratch() {
        super.initializeFromScratch();
        this.cosSetField(DK_V, CN_Version_1_2);
    }

    public boolean isActionAll() {
        return CN_All.equals(this.cosGetAction());
    }

    public boolean isActionExclude() {
        return CN_Exclude.equals(this.cosGetAction());
    }

    public boolean isActionInclude() {
        return CN_Include.equals(this.cosGetAction());
    }

    public void setPermissions(int n) {
        this.cosSetField(DK_P, COSInteger.create(n));
    }

    public void setVersion(String string) {
        this.cosSetField(DK_V, COSName.create(string));
    }

    public static class MetaClass
    extends PDObject.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }
    }
}

