/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAnnotationTools;
import de.intarsys.pdf.pd.PDAppearanceCharacteristics;
import java.util.Set;

public class PDWidgetAnnotation
extends PDAnnotation {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName DK_H = COSName.constant("H");
    public static final COSName CN_H_N = COSName.constant("N");
    public static final COSName CN_H_I = COSName.constant("I");
    public static final COSName CN_H_O = COSName.constant("O");
    public static final COSName CN_H_P = COSName.constant("P");
    public static final COSName CN_H_T = COSName.constant("T");
    public static final COSName DK_MK = COSName.constant("MK");
    public static final COSName CN_Subtype_Widget = COSName.constant("Widget");
    public static final COSName CN_State_Off = COSName.constant("Off");

    protected PDWidgetAnnotation(COSObject cOSObject) {
        super(cOSObject);
    }

    public boolean canReceiveFocus() {
        if (super.canReceiveFocus()) {
            PDAcroFormField pDAcroFormField = this.getAcroFormField();
            return !pDAcroFormField.isReadOnly() && (pDAcroFormField.isTypeTx() || pDAcroFormField.isTypeBtn() || pDAcroFormField.isTypeCh());
        }
        return false;
    }

    protected COSName cosGetExpectedSubtype() {
        return CN_Subtype_Widget;
    }

    public void dispose() {
        super.dispose();
        this.getAcroFormField().dispose(true);
    }

    public PDAcroFormField getAcroFormField() {
        return (PDAcroFormField)PDAcroFormField.META.createFromCos(this.cosGetDict());
    }

    public COSName getAltAppearanceState() {
        Set set = this.getAppearanceStates();
        set.add(COSName.create("Off"));
        COSName cOSName = this.getAppearanceState();
        for (COSName cOSName2 : set) {
            if (cOSName2.equals(cOSName)) continue;
            return cOSName2;
        }
        return null;
    }

    public PDAppearanceCharacteristics getAppearanceCharacteristics() {
        return (PDAppearanceCharacteristics)PDAppearanceCharacteristics.META.createFromCos(this.cosGetField(DK_MK));
    }

    public COSName getHighlightingMode() {
        COSName cOSName = this.cosGetField(DK_H).asName();
        if (cOSName != null) {
            return cOSName;
        }
        return CN_H_I;
    }

    public String getSubtypeLabel() {
        return "Widget";
    }

    public boolean isOff() {
        COSName cOSName = this.getAppearanceState();
        return cOSName == null || cOSName.equals(CN_State_Off);
    }

    public boolean isWidgetAnnotation() {
        return true;
    }

    public void setAppearanceCharacteristics(PDAppearanceCharacteristics pDAppearanceCharacteristics) {
        this.setFieldObject(DK_MK, pDAppearanceCharacteristics);
    }

    public void setHighlightingMode(COSName cOSName) {
        if (cOSName == null || CN_H_I.equals(cOSName)) {
            this.cosRemoveField(DK_H);
        } else {
            this.cosSetField(DK_H, cOSName);
        }
    }

    public void transform(CDSRectangle cDSRectangle, CDSMatrix cDSMatrix) {
        int n = 0;
        PDAppearanceCharacteristics pDAppearanceCharacteristics = this.getAppearanceCharacteristics();
        if (pDAppearanceCharacteristics != null) {
            n = pDAppearanceCharacteristics.getRotation();
        }
        PDAnnotationTools.transform(cDSRectangle, cDSMatrix, n);
    }

    public static class MetaClass
    extends PDAnnotation.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }

        protected COSBasedObject doCreateCOSBasedObject(COSObject cOSObject) {
            return new PDWidgetAnnotation(cOSObject);
        }
    }
}

