/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.st;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSTrailer;
import de.intarsys.pdf.crypt.ISystemSecurityHandler;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.st.AbstractXRefWriter;
import de.intarsys.pdf.st.STDocument;
import de.intarsys.pdf.st.STXRefEntry;
import de.intarsys.pdf.st.STXRefEntryFree;
import de.intarsys.pdf.st.STXRefSubsection;
import de.intarsys.pdf.writer.COSWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class STXRefSection {
    public static final COSName DK_XRefStm = COSName.constant("XRefStm");
    private STXRefSubsection xRefSubsection;
    private long offset = -1L;
    private STDocument doc;
    private STXRefSection previous;

    protected STXRefSection(STDocument sTDocument) {
        this(sTDocument, -1L);
    }

    protected STXRefSection(STDocument sTDocument, long l) {
        this.doc = sTDocument;
        this.offset = l;
        this.xRefSubsection = new STXRefSubsection(this, 0);
        this.xRefSubsection.addEntry(new STXRefEntryFree(0, 65535, 0));
    }

    public void addEntry(STXRefEntry sTXRefEntry) {
        STXRefSubsection sTXRefSubsection = null;
        STXRefSubsection sTXRefSubsection2 = this.getXRefSubsection();
        int n = sTXRefEntry.getObjectNumber();
        while (sTXRefSubsection2 != null) {
            int n2 = sTXRefSubsection2.getStart();
            int n3 = sTXRefSubsection2.getStop();
            if (n < n2) {
                STXRefSubsection sTXRefSubsection3 = new STXRefSubsection(this, n);
                sTXRefSubsection3.setNext(sTXRefSubsection2);
                if (sTXRefSubsection != null) {
                    sTXRefSubsection.setNext(sTXRefSubsection3);
                } else {
                    this.setXRefSubsection(sTXRefSubsection3);
                }
                sTXRefSubsection3.addEntry(sTXRefEntry);
                return;
            }
            if (n2 <= n && n <= n3) {
                sTXRefSubsection2.addEntry(sTXRefEntry);
                return;
            }
            sTXRefSubsection = sTXRefSubsection2;
            sTXRefSubsection2 = sTXRefSubsection2.getNext();
        }
        STXRefSubsection sTXRefSubsection4 = new STXRefSubsection(this, n);
        sTXRefSubsection4.setNext(null);
        if (sTXRefSubsection != null) {
            sTXRefSubsection.setNext(sTXRefSubsection4);
        } else {
            this.setXRefSubsection(sTXRefSubsection4);
        }
        sTXRefSubsection4.addEntry(sTXRefEntry);
    }

    public boolean contains(int n) {
        STXRefSubsection sTXRefSubsection = this.getXRefSubsection();
        while (sTXRefSubsection != null) {
            if (n < sTXRefSubsection.getStart()) {
                return false;
            }
            if (sTXRefSubsection.getStart() <= n && n < sTXRefSubsection.getStop()) {
                return true;
            }
            sTXRefSubsection = sTXRefSubsection.getNext();
        }
        return false;
    }

    public abstract COSDictionary cosGetDict();

    public abstract COSObject cosGetObject();

    protected void createNewSubsection(int n) {
    }

    public abstract STXRefSection createSuccessor();

    public Iterator entryIterator() {
        return new Iterator(){
            private Iterator currentIterator;
            private STXRefSubsection myNext;
            {
                this.myNext = STXRefSection.this.getXRefSubsection();
            }

            public boolean hasNext() {
                if (this.currentIterator != null && this.currentIterator.hasNext()) {
                    return true;
                }
                if (this.myNext != null) {
                    this.currentIterator = this.myNext.getEntries().iterator();
                    this.myNext = this.myNext.getNext();
                    return this.hasNext();
                }
                return false;
            }

            public Object next() {
                if (this.hasNext()) {
                    return this.currentIterator.next();
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public STDocument getDoc() {
        return this.doc;
    }

    public STXRefEntry getEntry(int n) {
        STXRefSubsection sTXRefSubsection = this.getXRefSubsection();
        while (sTXRefSubsection != null) {
            if (n < sTXRefSubsection.getStart()) {
                return null;
            }
            if (sTXRefSubsection.getStart() <= n && n < sTXRefSubsection.getStop()) {
                return sTXRefSubsection.getEntry(n);
            }
            sTXRefSubsection = sTXRefSubsection.getNext();
        }
        return null;
    }

    public COSArray getID() {
        return this.cosGetDict().get(COSTrailer.DK_ID).asArray();
    }

    public int getIncrementalCount() {
        if (this.getPrevious() == null) {
            return 1;
        }
        if (this.cosGetDict().get(COSTrailer.DK_Root).isNull()) {
            return this.getPrevious().getIncrementalCount();
        }
        return this.getPrevious().getIncrementalCount() + 1;
    }

    public int getMaxObjectNumber() {
        for (STXRefSubsection sTXRefSubsection = this.getXRefSubsection(); sTXRefSubsection != null; sTXRefSubsection = sTXRefSubsection.getNext()) {
            if (sTXRefSubsection.getNext() != null) {
                continue;
            }
            return sTXRefSubsection.getStop();
        }
        return 0;
    }

    public long getOffset() {
        return this.offset;
    }

    public STXRefSection getPrevious() {
        return this.previous;
    }

    public int getPreviousOffset() {
        COSInteger cOSInteger = this.cosGetDict().get(COSTrailer.DK_Prev).asInteger();
        if (cOSInteger == null) {
            return -1;
        }
        return cOSInteger.intValue();
    }

    protected int getPreviousXRefStmOffset() {
        COSInteger cOSInteger = this.cosGetDict().get(DK_XRefStm).asInteger();
        if (cOSInteger == null) {
            return -1;
        }
        return cOSInteger.intValue();
    }

    public int getSize() {
        COSInteger cOSInteger = this.cosGetDict().get(COSTrailer.DK_Size).asInteger();
        if (cOSInteger == null) {
            return -1;
        }
        return cOSInteger.intValue();
    }

    public int getStart() {
        return this.getXRefSubsection().getStart();
    }

    public abstract AbstractXRefWriter getWriter(COSWriter var1);

    protected int getXRefStmOffset() {
        COSInteger cOSInteger = this.cosGetDict().get(DK_XRefStm).asInteger();
        if (cOSInteger == null) {
            return -1;
        }
        return cOSInteger.intValue();
    }

    public STXRefSubsection getXRefSubsection() {
        return this.xRefSubsection;
    }

    protected abstract boolean isStreamed();

    public COSObject load(int n, ISystemSecurityHandler iSystemSecurityHandler) throws IOException, COSLoadException {
        if (this.contains(n)) {
            return this.getEntry(n).load(this.getDoc(), iSystemSecurityHandler);
        }
        if (this.getPrevious() != null) {
            return this.getPrevious().load(n, iSystemSecurityHandler);
        }
        return null;
    }

    protected void setCOSDoc(COSDocument cOSDocument) {
        cOSDocument.add(this.cosGetObject());
    }

    protected void setID(COSArray cOSArray) {
        this.cosGetDict().put(COSTrailer.DK_ID, cOSArray);
    }

    protected void setOffset(long l) {
        this.offset = l;
    }

    protected void setPrevious(STXRefSection sTXRefSection) {
        this.previous = sTXRefSection;
        if ((long)this.getPreviousOffset() != sTXRefSection.getOffset()) {
            this.setPreviousOffset(sTXRefSection.getOffset());
        }
    }

    protected void setPreviousOffset(long l) {
        this.cosGetDict().put(COSTrailer.DK_Prev, COSInteger.create((int)l));
    }

    protected void setSize(int n) {
        this.cosGetDict().put(COSTrailer.DK_Size, COSInteger.create(n));
    }

    protected void setXRefStmOffset(long l) {
        this.cosGetDict().put(DK_XRefStm, COSInteger.create((int)l));
    }

    protected void setXRefSubsection(STXRefSubsection sTXRefSubsection) {
        this.xRefSubsection = sTXRefSubsection;
        STXRefSubsection sTXRefSubsection2 = this.getXRefSubsection();
        while (sTXRefSubsection2 != null) {
            sTXRefSubsection2.setXRefSection(this);
            sTXRefSubsection2 = sTXRefSubsection2.getNext();
        }
    }

    public Iterator subsectionIterator() {
        return new Iterator(){
            private STXRefSubsection current;
            {
                this.current = STXRefSection.this.getXRefSubsection();
            }

            public boolean hasNext() {
                return this.current != null;
            }

            public Object next() {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                STXRefSubsection sTXRefSubsection = this.current;
                this.current = this.current.getNext();
                return sTXRefSubsection;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

