/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.enumeration;

import de.intarsys.tools.enumeration.EnumMeta;
import de.intarsys.tools.message.Message;
import java.util.HashMap;
import java.util.Map;

public abstract class EnumItem
implements Comparable {
    private static final Map META = new HashMap();
    private static int WEIGHT = 0;
    private String iconName;
    private final String id;
    private String label;
    private Message message;
    private final int weight;

    protected static EnumMeta getMeta(Class clazz) {
        EnumMeta enumMeta = (EnumMeta)META.get(clazz);
        if (enumMeta == null) {
            enumMeta = new EnumMeta(clazz);
            META.put(clazz, enumMeta);
        }
        return enumMeta;
    }

    protected EnumItem(String string) {
        this.id = string;
        this.message = new Message(this, string);
        this.weight = WEIGHT++;
        this.getMeta().addItem(this);
    }

    protected EnumItem(String string, int n) {
        this.id = string;
        this.message = new Message(this, string);
        this.weight = n;
        this.getMeta().addItem(this);
    }

    protected EnumItem(String string, Message message) {
        this(string, message, WEIGHT++);
    }

    protected EnumItem(String string, Message message, int n) {
        this.id = string;
        this.message = message;
        this.weight = n;
        this.getMeta().addItem(this);
    }

    protected EnumItem(String string, String string2) {
        this(string, string2, WEIGHT++);
    }

    protected EnumItem(String string, String string2, int n) {
        this.id = string;
        this.label = string2;
        this.weight = n;
        this.getMeta().addItem(this);
    }

    public int compareTo(Object object) {
        EnumItem enumItem = (EnumItem)object;
        return (int)Math.signum(this.getWeight() - enumItem.getWeight());
    }

    public String getDescription() {
        return this.getTip();
    }

    public String getIconName() {
        return this.iconName;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        if (this.label == null) {
            this.label = this.message.get();
        }
        return this.label;
    }

    public String getLocalizedLabel() {
        return this.getLabel();
    }

    public Message getMessage() {
        return this.message;
    }

    protected EnumMeta getMeta() {
        return EnumItem.getMeta(this.getClass());
    }

    public String getTip() {
        return this.getLabel();
    }

    protected int getWeight() {
        return this.weight;
    }

    protected void setDefault() {
        this.getMeta().setDefault(this);
    }

    protected void setIconName(String string) {
        this.iconName = string;
    }

    public String toString() {
        return this.getLabel();
    }
}

