/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.enumeration;

import de.intarsys.tools.enumeration.EnumItem;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumMeta<T extends EnumItem> {
    private final Class enumClazz;
    private final List<T> items = new ArrayList<T>();
    private T enumDefault = null;

    public EnumMeta(Class clazz) {
        this.enumClazz = clazz;
    }

    protected void addItem(T t) {
        this.items.add(t);
    }

    public T getDefault() {
        return this.enumDefault;
    }

    public Class getEnumClazz() {
        return this.enumClazz;
    }

    public T getItem(String string) {
        if (string == null) {
            return null;
        }
        for (EnumItem enumItem : this.items) {
            if (!enumItem.getId().equals(string)) continue;
            return (T)enumItem;
        }
        return null;
    }

    public T getItemOrDefault(String string) {
        T t = this.getItem(string);
        if (t == null) {
            t = this.getDefault();
        }
        return t;
    }

    public T[] getItems() {
        return this.items.toArray(new EnumItem[this.items.size()]);
    }

    public T getMax() {
        EnumItem enumItem = null;
        for (EnumItem enumItem2 : this.items) {
            if (enumItem != null && enumItem2.getWeight() <= enumItem.getWeight()) continue;
            enumItem = enumItem2;
        }
        return (T)enumItem;
    }

    public T getMin() {
        EnumItem enumItem = null;
        for (EnumItem enumItem2 : this.items) {
            if (enumItem != null && enumItem2.getWeight() >= enumItem.getWeight()) continue;
            enumItem = enumItem2;
        }
        return (T)enumItem;
    }

    protected void setDefault(T t) {
        this.enumDefault = t;
    }
}

