/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.file;

import de.intarsys.tools.file.TempTools;
import de.intarsys.tools.logging.LogTools;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class FileTools {
    public static final String DIRECTORY_LOCK = "directory.lock";
    static final Logger Log = LogTools.getLogger(FileTools.class);
    private static Map<File, Lock> maps = new HashMap<File, Lock>();

    public static void appendFile(File file, File file2) throws IOException {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        if (FileTools.equalsOnSystem(file, file2)) {
            return;
        }
        try {
            try {
                fileInputStream = new FileInputStream(file);
                fileOutputStream = new FileOutputStream(file2, true);
                StreamTools.copyStream(fileInputStream, false, fileOutputStream, false);
            }
            catch (Exception exception) {
                throw new IOException("copying failed (" + exception.getMessage() + ")");
            }
        }
        catch (Throwable throwable) {
            StreamTools.close(fileInputStream);
            StreamTools.close(fileOutputStream);
            throw throwable;
        }
        StreamTools.close(fileInputStream);
        StreamTools.close(fileOutputStream);
    }

    public static File checkDirectory(File file, boolean bl, boolean bl2, boolean bl3) throws IOException {
        if (file == null) {
            return file;
        }
        if (!file.exists() && bl && !file.mkdirs()) {
            throw new IOException("Can't create directory " + file.getPath());
        }
        if (!file.exists()) {
            throw new IOException("Can't create directory " + file.getPath());
        }
        if (!file.isDirectory()) {
            throw new IOException("Can't create directory " + file.getPath());
        }
        if (bl2 && !file.canRead()) {
            throw new IOException("No read access for directory " + file.getPath());
        }
        if (bl3 && !file.canWrite()) {
            throw new IOException("No write access for directory " + file.getPath());
        }
        return file;
    }

    public static File checkDirectory(String string, boolean bl, boolean bl2, boolean bl3) throws IOException {
        return FileTools.checkDirectory(new File(string), bl, bl2, bl3);
    }

    public static void copyBinaryFile(File file, File file2) throws IOException {
        if (!file2.getParentFile().exists()) {
            file2.getParentFile().mkdirs();
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            StreamTools.copyStream(fileInputStream, fileOutputStream);
        }
        catch (Throwable throwable) {
            StreamTools.close(fileInputStream);
            StreamTools.close(fileOutputStream);
            throw throwable;
        }
        StreamTools.close(fileInputStream);
        StreamTools.close(fileOutputStream);
        file2.setLastModified(file.lastModified());
    }

    public static void copyFile(File file, File file2) throws IOException {
        FileTools.copyBinaryFile(file, file2);
    }

    public static void copyFile(File file, String string, File file2, String string2) throws IOException {
        if (string == null || string2 == null || string.equals(string2)) {
            FileTools.copyBinaryFile(file, file2);
            return;
        }
        if (!file2.getParentFile().exists()) {
            file2.getParentFile().mkdirs();
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(file);
                fileOutputStream = new FileOutputStream(file2);
                StreamTools.copyEncodedStream(fileInputStream, string, fileOutputStream, string2);
            }
            catch (Exception exception) {
                throw new IOException("copying failed (" + exception.getMessage() + ")");
            }
        }
        catch (Throwable throwable) {
            StreamTools.close(fileInputStream);
            StreamTools.close(fileOutputStream);
            throw throwable;
        }
        StreamTools.close(fileInputStream);
        StreamTools.close(fileOutputStream);
    }

    public static void copyRecursively(File file, File file2) throws IOException {
        if (file.isFile()) {
            FileTools.copyFile(file, file2);
            return;
        }
        if (!file.isDirectory()) {
            throw new IOException("file '" + file.getAbsolutePath() + "' does not exist.");
        }
        if (file2.isFile()) {
            throw new IOException("cannot copy directory into file");
        }
        file2.mkdirs();
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            FileTools.copyRecursively(new File(file, stringArray[n]), new File(file2, stringArray[n]));
            ++n;
        }
    }

    public static File copyRecursivelyInto(File file, File file2, String string) throws IOException {
        if (file2.isFile()) {
            throw new IOException("can't copy into file");
        }
        String string2 = string == null ? file.getName() : string;
        File file3 = new File(file2, string2);
        if (file.equals(file3)) {
            return file3;
        }
        if (file.isFile()) {
            FileTools.copyFile(file, file3);
            return file3;
        }
        if (!file.isDirectory()) {
            throw new IOException("file '" + file.getAbsolutePath() + "' does not exist.");
        }
        String[] stringArray = file.list();
        file3.mkdirs();
        int n = 0;
        while (n < stringArray.length) {
            FileTools.copyRecursivelyInto(new File(file, stringArray[n]), file3, stringArray[n]);
            ++n;
        }
        return file3;
    }

    public static void createEmptyFile(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        StreamTools.close(fileOutputStream);
    }

    public static File createTempFile(File file) throws IOException {
        String string;
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        if (n >= 0) {
            string = string2.substring(n);
            string2 = string2.substring(0, n);
        } else {
            string = "";
        }
        if (string2.length() < 3) {
            string2 = "tmp" + string2;
        }
        return TempTools.createTempFile(string2, string);
    }

    public static File createTempFile(String string) throws IOException {
        return FileTools.createTempFile(new File(string));
    }

    public static void deleteAfter(File file, long l, boolean bl) throws IOException {
        if (l <= 0L) {
            return;
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            throw new IOException("can not list " + file);
        }
        long l2 = System.currentTimeMillis() - l;
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(file, stringArray[n]);
            if (file2.isDirectory() && bl) {
                FileTools.deleteAfter(file2, l, bl);
            }
            if (file2.lastModified() < l2) {
                file2.delete();
            }
            ++n;
        }
    }

    public static boolean deleteRecursivly(File file) {
        return FileTools.deleteRecursivly(file, true);
    }

    public static boolean deleteRecursivly(File file, boolean bl) {
        if (file == null || !file.exists()) {
            return true;
        }
        if (file.isFile()) {
            return file.delete();
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            return false;
        }
        if (stringArray.length == 0) {
            return file.delete();
        }
        int n = 0;
        while (n < stringArray.length) {
            if (!FileTools.deleteRecursivly(new File(file, stringArray[n]))) {
                return false;
            }
            ++n;
        }
        if (bl) {
            return file.delete();
        }
        return true;
    }

    public static boolean equalsOnSystem(File file, File file2) {
        try {
            if (FileTools.isWindows()) {
                return file.getCanonicalPath().equalsIgnoreCase(file2.getCanonicalPath());
            }
            return file.getCanonicalPath().equals(file2.getCanonicalPath());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static String getBaseName(File file) {
        if (file == null) {
            return FileTools.getBaseName(null, "");
        }
        return FileTools.getBaseName(file.getName(), "");
    }

    public static String getBaseName(File file, String string) {
        if (file == null) {
            return FileTools.getBaseName(null, string);
        }
        return FileTools.getBaseName(file.getName(), string);
    }

    public static String getBaseName(String string) {
        return FileTools.getBaseName(string, "");
    }

    public static String getBaseName(String string, String string2) {
        if (StringTools.isEmpty(string)) {
            return string2;
        }
        int n = string.lastIndexOf(46);
        if (n >= 1) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String getEncoding() {
        return System.getProperty("file.encoding");
    }

    public static String getExtension(File file) {
        return FileTools.getExtension(file.getName());
    }

    public static String getExtension(String string) {
        return FileTools.getExtension(string, "");
    }

    public static String getExtension(String string, String string2) {
        if (StringTools.isEmpty(string)) {
            return string2;
        }
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string2;
    }

    public static File getParentFile(File file) {
        String string;
        File file2 = file.getParentFile();
        if (file2 == null) {
            file2 = file.getAbsoluteFile().getParentFile();
        }
        if (file2 == null) {
            return null;
        }
        File file3 = file2.getParentFile();
        if (file3 != null && (string = file3.getAbsolutePath()).equals("\\\\")) {
            return null;
        }
        return file2;
    }

    private static List getPathList(File file) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file2 = file.getCanonicalFile();
        while (file2 != null) {
            if (file2.getName().length() == 0) {
                int n = file2.getPath().indexOf(":");
                if (n == -1) {
                    arrayList.add("");
                } else {
                    arrayList.add(file2.getPath().substring(0, n));
                }
            } else {
                arrayList.add(file2.getName());
            }
            file2 = file2.getParentFile();
        }
        ArrayList arrayList2 = new ArrayList();
        int n = arrayList.size() - 1;
        while (n >= 0) {
            arrayList2.add(arrayList.get(n));
            --n;
        }
        return arrayList2;
    }

    public static String getPathRelativeTo(File file, File file2) throws IOException {
        String string = null;
        if (file2 != null) {
            List list = FileTools.getPathList(file);
            List list2 = FileTools.getPathList(file2);
            string = FileTools.matchPathLists(list, list2);
        }
        if (string == null) {
            return file.getAbsolutePath();
        }
        return string;
    }

    public static boolean isAncestor(File file, File file2) {
        if (file == null) {
            return false;
        }
        File file3 = file2;
        while (!file.equals(file3)) {
            if (file3 == null) {
                return false;
            }
            file3 = file3.getParentFile();
        }
        return true;
    }

    public static boolean isWindows() {
        return File.separatorChar == '\\';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Lock lock(File file) {
        Map<File, Lock> map = maps;
        synchronized (map) {
            block10: {
                if (maps.get(file) == null) break block10;
                return null;
            }
            FileOutputStream fileOutputStream = null;
            AbstractInterruptibleChannel abstractInterruptibleChannel = null;
            File file2 = null;
            try {
                file2 = file.isFile() ? new File(String.valueOf(file.getAbsolutePath()) + ".lock") : new File(file, DIRECTORY_LOCK);
                fileOutputStream = new FileOutputStream(file2);
                abstractInterruptibleChannel = fileOutputStream.getChannel();
                ((FileChannel)abstractInterruptibleChannel).tryLock();
                Lock lock = new Lock();
                lock.file = file;
                lock.lockFile = file2;
                lock.lockStream = fileOutputStream;
                maps.put(file, lock);
                return lock;
            }
            catch (Exception exception) {
                StreamTools.close(fileOutputStream);
                if (abstractInterruptibleChannel != null) {
                    try {
                        abstractInterruptibleChannel.close();
                    }
                    catch (IOException iOException) {}
                }
                if (file2 != null) {
                    file2.delete();
                }
                return null;
            }
        }
    }

    private static String matchPathLists(List list, List list2) {
        Iterator iterator = list2.iterator();
        Iterator iterator2 = list.iterator();
        boolean bl = false;
        while (iterator.hasNext() && iterator2.hasNext()) {
            if (!iterator.next().equals(iterator2.next())) break;
            iterator.remove();
            iterator2.remove();
            bl = true;
        }
        if (!bl) {
            return null;
        }
        String string = "";
        int n = 0;
        while (n < list2.size()) {
            string = String.valueOf(string) + ".." + File.separator;
            ++n;
        }
        Iterator iterator3 = list.iterator();
        while (iterator3.hasNext()) {
            string = String.valueOf(string) + iterator3.next();
            if (!iterator3.hasNext()) continue;
            string = String.valueOf(string) + File.separator;
        }
        return string;
    }

    public static void renameFile(File file, File file2) throws IOException {
        FileTools.renameFile(file, null, file2, null);
    }

    public static void renameFile(File file, String string, File file2, String string2) throws IOException {
        if (file.getCanonicalFile().equals(file2.getCanonicalFile())) {
            return;
        }
        if (string != null && string2 != null && !string.equals(string2) || !file.renameTo(file2)) {
            FileTools.copyFile(file, string, file2, string2);
            if (!file.delete()) {
                file2.delete();
                throw new IOException("deleting " + file + " failed");
            }
        }
    }

    public static File resolvePath(File file, String string) {
        if (StringTools.isEmpty(string)) {
            return file == null ? new File("") : file;
        }
        if (file == null) {
            return new File(string);
        }
        File file2 = new File(string);
        if (file2.isAbsolute()) {
            return file2;
        }
        return new File(file, string);
    }

    public static byte[] toBytes(File file) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            byte[] byArray = StreamTools.toByteArray(fileInputStream);
            return byArray;
        }
        finally {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
    }

    public static String toString(File file) throws IOException {
        return FileTools.toString(file, System.getProperty("file.encoding"));
    }

    public static String toString(File file, String string) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            String string2 = StreamTools.toString(fileInputStream, string);
            return string2;
        }
        finally {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
    }

    public static String trimPath(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        String string3 = "";
        if (string2.length() >= 2 && string2.charAt(1) == ':') {
            string3 = string2.substring(0, 2);
            string2 = string2.substring(2);
        }
        string2 = string2.replaceAll("[\\*\"\\?\\<\\>\\|\\:!\\n\\t\\r\\f]", "_");
        return String.valueOf(string3) + string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void unlock(Lock lock) {
        Map<File, Lock> map = maps;
        synchronized (map) {
            maps.remove(lock.file);
            lock.valid = false;
            StreamTools.close(lock.lockStream);
            lock.lockFile.delete();
        }
    }

    public static void wait(File file, long l, long l2) throws IOException {
        long l3 = System.currentTimeMillis() + l;
        try {
            while (true) {
                if (file.exists()) {
                    if (l2 > 0L) {
                        long l4 = -1L;
                        long l5 = file.length();
                        while (l4 != l5) {
                            l4 = l5;
                            Thread.sleep(l2);
                            l5 = file.length();
                        }
                    }
                    return;
                }
                if (System.currentTimeMillis() > l3) {
                    throw new IOException("timeout waiting for " + file.getPath());
                }
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("interrupted waiting for " + file.getPath());
        }
    }

    public static void write(File file, byte[] byArray) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            fileOutputStream.write(byArray);
        }
        finally {
            StreamTools.close(fileOutputStream);
        }
    }

    public static void write(File file, String string) throws IOException {
        FileTools.write(file, string, Charset.defaultCharset().name(), false);
    }

    public static void write(File file, String string, boolean bl) throws IOException {
        FileTools.write(file, string, Charset.defaultCharset().name(), bl);
    }

    public static void write(File file, String string, String string2) throws IOException {
        FileTools.write(file, string, string2, false);
    }

    public static void write(File file, String string, String string2, boolean bl) throws IOException {
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        try {
            fileOutputStream = new FileOutputStream(file, bl);
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, string2);
            outputStreamWriter.write(string);
        }
        catch (Throwable throwable) {
            StreamTools.close(outputStreamWriter);
            StreamTools.close(fileOutputStream);
            throw throwable;
        }
        StreamTools.close(outputStreamWriter);
        StreamTools.close(fileOutputStream);
    }

    private FileTools() {
    }

    public static class Lock {
        protected File file;
        protected File lockFile;
        protected FileOutputStream lockStream;
        protected boolean valid = true;

        public synchronized boolean isValid() {
            return this.valid;
        }

        public synchronized void release() {
            FileTools.unlock(this);
        }
    }
}

