/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.file;

import de.intarsys.tools.file.FileTools;
import java.io.File;
import java.io.FileFilter;

public class TempTools {
    private static File tempDir;
    private static File tempDirVM;
    private static FileTools.Lock lock;
    private static int fileCounter;
    private static int dirCounter;

    static {
        fileCounter = 0;
        dirCounter = 0;
        TempTools.cleanUp();
    }

    protected static void cleanUp() {
        File[] fileArray = TempTools.getTempDir().listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() && file.getName().startsWith(TempTools.class.getName());
            }
        });
        if (fileArray == null) {
            return;
        }
        int n = 0;
        while (n < fileArray.length) {
            TempTools.cleanUpTempDir(fileArray[n]);
            ++n;
        }
    }

    protected static void cleanUpTempDir(File file) {
        FileTools.Lock lock = FileTools.lock(file);
        if (lock == null) {
            return;
        }
        lock.release();
        FileTools.deleteRecursivly(file);
    }

    public static synchronized File createTempDir(String string, String string2) {
        String string3 = String.valueOf(string) + dirCounter++ + string2;
        File file = new File(TempTools.getTempDirVM(), string3);
        file.mkdirs();
        return file;
    }

    protected static File createTempDirVM(File file) {
        String string = TempTools.class.getName();
        File file2 = new File(file, string);
        int n = 0;
        while ((file2 = new File(file, String.valueOf(string) + "_" + n)).exists() || !file2.mkdirs() || (lock = FileTools.lock(file2)) == null) {
            ++n;
        }
        return file2;
    }

    public static synchronized File createTempFile(String string, String string2) {
        String string3 = String.valueOf(string) + fileCounter++ + string2;
        File file = new File(TempTools.getTempDirVM(), string3);
        return file;
    }

    public static File getTempDir() {
        if (tempDir == null) {
            tempDir = new File(System.getProperty("java.io.tmpdir"));
        }
        return tempDir;
    }

    public static File getTempDirVM() {
        if (tempDirVM == null) {
            tempDirVM = TempTools.createTempDirVM(TempTools.getTempDir());
        }
        return tempDirVM;
    }

    public static void setTempDir(File file) {
        tempDir = file;
    }
}

