/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor;

import de.intarsys.tools.enumeration.EnumItem;
import de.intarsys.tools.enumeration.EnumMeta;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.FunctorInvocationException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.reflect.ClassTools;
import de.intarsys.tools.string.Converter;
import de.intarsys.tools.string.StringTools;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgTools {
    public static final IFunctor toString = new IFunctor(){

        public Object perform(IFunctorCall iFunctorCall) throws FunctorInvocationException {
            Args args = (Args)iFunctorCall.getReceiver();
            StringBuilder stringBuilder = new StringBuilder();
            if (args.isNamed()) {
                for (String string : args.names()) {
                    stringBuilder.append(string);
                    stringBuilder.append(" = ");
                    stringBuilder.append(args.get(string));
                    stringBuilder.append("\n");
                }
            } else {
                int n = 0;
                while (n < args.size()) {
                    stringBuilder.append(n);
                    stringBuilder.append(" = ");
                    stringBuilder.append(args.get(n));
                    stringBuilder.append("\n");
                    ++n;
                }
            }
            return stringBuilder.toString();
        }
    };
    private static Set visited;
    private static int nesting;

    static {
        nesting = 0;
    }

    protected static ILocator createLocator(Object object, ILocator iLocator, ILocatorFactory iLocatorFactory) {
        if (object == null) {
            return iLocator;
        }
        if (object instanceof ILocator) {
            return (ILocator)object;
        }
        if (object instanceof File) {
            try {
                return iLocatorFactory.createLocator(((File)object).getAbsolutePath());
            }
            catch (IOException iOException) {
                return iLocator;
            }
        }
        if (object instanceof String) {
            if (StringTools.isEmpty((String)object)) {
                return iLocator;
            }
            try {
                return iLocatorFactory.createLocator((String)object);
            }
            catch (IOException iOException) {
                return iLocator;
            }
        }
        return iLocator;
    }

    public static IArgs getArgs(IArgs iArgs, String string, IArgs iArgs2) {
        if (iArgs == null) {
            return iArgs2;
        }
        Object object = iArgs.get(string);
        if (object == null) {
            return iArgs2;
        }
        if (object instanceof IArgs) {
            return (IArgs)object;
        }
        if (object instanceof String) {
            object = Converter.asMap((String)object);
        }
        if (object instanceof Map) {
            return new Args((Map)object);
        }
        if (object instanceof List) {
            return new Args((List)object);
        }
        return iArgs2;
    }

    public static boolean getBool(IArgs iArgs, String string, boolean bl) {
        if (iArgs == null) {
            return bl;
        }
        Object object = iArgs.get(string);
        if (object == null) {
            return bl;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            String string2 = (String)object;
            return Converter.asBoolean(string2, bl);
        }
        return bl;
    }

    public static byte getByte(IArgs iArgs, String string, byte by) {
        if (iArgs == null) {
            return by;
        }
        Object object = iArgs.get(string);
        if (object instanceof Number) {
            return ((Number)object).byteValue();
        }
        if (object instanceof String) {
            try {
                return Byte.parseByte((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return by;
            }
        }
        return by;
    }

    public static char getChar(IArgs iArgs, String string, char c) {
        String string2;
        if (iArgs == null) {
            return c;
        }
        Object object = iArgs.get(string);
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        if (object instanceof String && (string2 = (String)object).length() > 0) {
            return string2.charAt(0);
        }
        return c;
    }

    public static char[] getCharArray(IArgs iArgs, String string, char[] cArray) throws IllegalArgumentException {
        if (iArgs == null) {
            return cArray;
        }
        Object object = iArgs.get(string);
        if (object == null) {
            return cArray;
        }
        if (object instanceof char[]) {
            return (char[])object;
        }
        if (object instanceof String) {
            return ((String)object).toCharArray();
        }
        throw new IllegalArgumentException("argument '" + string + "' must be of type string or char[]");
    }

    public static Class getClass(IArgs iArgs, String string, Class clazz) {
        if (iArgs == null) {
            return clazz;
        }
        Object object = iArgs.get(string);
        if (object == null) {
            return clazz;
        }
        if (object instanceof Class) {
            return (Class)object;
        }
        if (object instanceof String) {
            String string2 = (String)object;
            try {
                return ClassTools.createClass(string2, Object.class, null);
            }
            catch (Exception exception) {
                return clazz;
            }
        }
        return clazz;
    }

    public static Date getDate(IArgs iArgs, String string, Date date) {
        if (iArgs == null) {
            return date;
        }
        Object object = iArgs.get(string);
        if (object == null) {
            return date;
        }
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof String) {
            String string2 = (String)object;
            try {
                return DateFormat.getInstance().parse(string2);
            }
            catch (ParseException parseException) {
                return date;
            }
        }
        return date;
    }

    public static <T extends EnumItem> T getEnumItem(IArgs iArgs, EnumMeta<T> enumMeta, String string) {
        if (iArgs == null) {
            return enumMeta.getDefault();
        }
        Object object = iArgs.get(string);
        if (object == null) {
            return enumMeta.getDefault();
        }
        if (object instanceof EnumItem) {
            return (T)((EnumItem)object);
        }
        if (object instanceof String) {
            String string2 = (String)object;
            return enumMeta.getItemOrDefault(string2);
        }
        return enumMeta.getDefault();
    }

    public static <T extends EnumItem> T getEnumItem(IArgs iArgs, EnumMeta<T> enumMeta, String string, String string2) {
        if (iArgs == null) {
            return enumMeta.getItemOrDefault(string2);
        }
        Object object = iArgs.get(string);
        if (object == null) {
            return enumMeta.getItemOrDefault(string2);
        }
        if (object instanceof EnumItem) {
            return (T)((EnumItem)object);
        }
        if (object instanceof String) {
            String string3 = (String)object;
            return enumMeta.getItemOrDefault(string3);
        }
        return enumMeta.getItemOrDefault(string2);
    }

    public static File getFile(IArgs iArgs, String string, File file) {
        if (iArgs == null) {
            return file;
        }
        Object object = iArgs.get(string);
        if (object instanceof File) {
            return (File)object;
        }
        if (object instanceof String) {
            return new File((String)object);
        }
        if (object instanceof FileLocator) {
            return ((FileLocator)object).getFile();
        }
        if (object instanceof ILocator) {
            return new File(((ILocator)object).getFullName());
        }
        return file;
    }

    public static float getFloat(IArgs iArgs, String string, float f) {
        if (iArgs == null) {
            return f;
        }
        Object object = iArgs.get(string);
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        if (object instanceof String) {
            String string2 = (String)object;
            if (string2.indexOf("%") != -1) {
                try {
                    Number number = NumberFormat.getPercentInstance().parse(string2);
                    return number.floatValue();
                }
                catch (ParseException parseException) {
                    return f;
                }
            }
            try {
                return Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return f;
            }
        }
        return f;
    }

    public static int getInt(IArgs iArgs, String string, int n) {
        if (iArgs == null) {
            return n;
        }
        Object object = iArgs.get(string);
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return n;
            }
        }
        return n;
    }

    public static ILocator getLocator(IArgs iArgs, String string, ILocator iLocator, ILocatorFactory iLocatorFactory) {
        if (iArgs == null) {
            return iLocator;
        }
        Object object = iArgs.get(string);
        return ArgTools.createLocator(object, iLocator, iLocatorFactory);
    }

    public static List<ILocator> getLocators(IArgs iArgs, String string, ILocatorFactory iLocatorFactory) {
        if (iArgs == null) {
            return null;
        }
        Object object = iArgs.get(string);
        if (object == null) {
            return null;
        }
        ArrayList<ILocator> arrayList = new ArrayList<ILocator>();
        if (object instanceof Collection) {
            for (Object e : (Collection)object) {
                ILocator iLocator = ArgTools.createLocator(e, null, iLocatorFactory);
                if (iLocator == null) continue;
                arrayList.add(iLocator);
            }
        } else {
            ILocator iLocator = ArgTools.createLocator(object, null, iLocatorFactory);
            if (iLocator != null) {
                arrayList.add(iLocator);
            }
        }
        return arrayList;
    }

    public static Map getMap(IArgs iArgs, String string, Map map) {
        if (iArgs == null) {
            return map;
        }
        Object object = iArgs.get(string);
        if (object == null) {
            return map;
        }
        if (object instanceof Map) {
            return (Map)object;
        }
        if (object instanceof String) {
            return Converter.asMap((String)object);
        }
        return map;
    }

    public static Object getObject(IArgs iArgs, String string, Object object) {
        if (iArgs == null) {
            return object;
        }
        Object object2 = iArgs.get(string);
        if (object2 == null) {
            return object;
        }
        return object2;
    }

    public static Point2D getPoint(IArgs iArgs, String string, Point2D point2D) {
        if (iArgs == null) {
            return point2D;
        }
        Object object = iArgs.get(string);
        if (object == null) {
            return point2D;
        }
        if (object instanceof Point2D) {
            return (Point2D)object;
        }
        if (object instanceof String) {
            String string2 = (String)object;
            String[] stringArray = string2.split("[x*@]");
            if (stringArray == null || stringArray.length != 2) {
                return point2D;
            }
            try {
                float f = Float.parseFloat(stringArray[0]);
                float f2 = Float.parseFloat(stringArray[1]);
                return new Point2D.Float(f, f2);
            }
            catch (NumberFormatException numberFormatException) {
                return point2D;
            }
        }
        return point2D;
    }

    public static String getString(IArgs iArgs, String string, String string2) {
        if (iArgs == null) {
            return string2;
        }
        Object object = iArgs.get(string);
        if (object == null) {
            return string2;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof char[]) {
            return new String((char[])object);
        }
        return String.valueOf(object);
    }

    public static String prefix(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (string == null || string.length() == 0) {
            return string2;
        }
        return String.valueOf(string) + Character.toUpperCase(string2.charAt(0)) + string2.substring(1);
    }

    public static IArgs toArgs(Object object) {
        if (object instanceof IArgs) {
            return (IArgs)object;
        }
        if (object instanceof String) {
            object = Converter.asMap((String)object);
        }
        if (object instanceof Map) {
            return new Args((Map)object);
        }
        if (object instanceof List) {
            return new Args((List)object);
        }
        return Args.EMPTY;
    }

    public static List toList(IArgs iArgs) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = iArgs.size();
        while (n > 0) {
            arrayList.add(iArgs.get(--n));
        }
        return arrayList;
    }

    public static Map toMap(IArgs iArgs) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (String string : iArgs.names()) {
            hashMap.put(string, iArgs.get(string));
        }
        return hashMap;
    }

    public static synchronized String toString(IArgs iArgs, String string) {
        if (visited == null) {
            visited = new HashSet();
            nesting = 0;
        }
        if (visited.contains(iArgs)) {
            return "...recursive...";
        }
        if (nesting == 4) {
            return "...nested to deeply...";
        }
        visited.add(iArgs);
        ++nesting;
        try {
            StringBuilder stringBuilder = new StringBuilder();
            if (iArgs.isNamed()) {
                Object object;
                for (String string2 : iArgs.names()) {
                    object = iArgs.get(string2);
                    if (object instanceof IArgs) continue;
                    ArgTools.toStringPlain(string, stringBuilder, string2, object);
                }
                for (String string2 : iArgs.names()) {
                    object = iArgs.get(string2);
                    if (!(object instanceof IArgs)) continue;
                    ArgTools.toStringArgs(string, stringBuilder, string2, (IArgs)object);
                }
            } else {
                int n = 0;
                while (n < iArgs.size()) {
                    Object object = iArgs.get(n);
                    if (object instanceof IArgs) {
                        ArgTools.toStringArgs(string, stringBuilder, "" + n, (IArgs)object);
                    } else {
                        ArgTools.toStringPlain(string, stringBuilder, "" + n, object);
                    }
                    ++n;
                }
            }
            String string3 = stringBuilder.toString();
            return string3;
        }
        finally {
            if (--nesting == 0) {
                visited = null;
            }
        }
    }

    protected static void toStringArgs(String string, StringBuilder stringBuilder, String string2, IArgs iArgs) {
        int n = 1;
        while (n < nesting) {
            stringBuilder.append("   ");
            ++n;
        }
        stringBuilder.append(string2);
        stringBuilder.append(" = ");
        stringBuilder.append("{");
        stringBuilder.append("\n");
        stringBuilder.append(ArgTools.toString(iArgs, string));
        stringBuilder.append("\n");
        n = 1;
        while (n < nesting) {
            stringBuilder.append("   ");
            ++n;
        }
        stringBuilder.append("}");
        stringBuilder.append("\n");
    }

    protected static void toStringPlain(String string, StringBuilder stringBuilder, String string2, Object object) {
        int n = 1;
        while (n < nesting) {
            stringBuilder.append("   ");
            ++n;
        }
        stringBuilder.append(string2);
        stringBuilder.append(" = ");
        stringBuilder.append(StringTools.safeString(object));
        stringBuilder.append("\n");
    }
}

