/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.CommonLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;

public class ClassResourceLocator
extends CommonLocator {
    private final Class clazz;
    private final String name;
    private final String resolvedName;
    private String encoding;
    private ILocator tempFileLocator;

    public ClassResourceLocator(Class clazz, String string) {
        this.clazz = clazz;
        this.name = string;
        this.resolvedName = this.resolveName(string);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ClassResourceLocator)) {
            return false;
        }
        return this.getResolvedName().equals(((ClassResourceLocator)object).getResolvedName());
    }

    public boolean exists() {
        return this.getClazz().getResource(this.getResolvedName()) != null;
    }

    public ILocator getChild(String string) {
        String string2 = String.valueOf(this.getResolvedName()) + "/" + string;
        ClassResourceLocator classResourceLocator = new ClassResourceLocator(this.getClazz(), string2);
        return classResourceLocator;
    }

    public Class getClazz() {
        return this.clazz;
    }

    protected String getEncoding() {
        return this.encoding;
    }

    public String getFullName() {
        return this.getResolvedName();
    }

    public InputStream getInputStream() throws IOException {
        return this.getClazz().getResourceAsStream(this.getResolvedName());
    }

    public String getLocalName() {
        if (this.getName() == null) {
            return "unknown";
        }
        return FileTools.getBaseName(this.getName());
    }

    public String getName() {
        return this.name;
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("locator is read only");
    }

    public ILocator getParent() {
        int n = this.getResolvedName().lastIndexOf("/");
        if (n > -1) {
            String string = this.getResolvedName().substring(0, n);
            return new ClassResourceLocator(this.getClazz(), string);
        }
        return null;
    }

    public synchronized IRandomAccess getRandomAccess() throws IOException {
        if (this.tempFileLocator == null) {
            this.tempFileLocator = this.createTempFileLocator();
        }
        return this.tempFileLocator.getRandomAccess();
    }

    public Reader getReader() throws IOException {
        if (this.getEncoding() == null) {
            return new InputStreamReader(this.getInputStream());
        }
        return new InputStreamReader(this.getInputStream(), this.getEncoding());
    }

    public Reader getReader(String string) throws IOException {
        if (string == null || string.equals("")) {
            return this.getReader();
        }
        return new InputStreamReader(this.getInputStream(), string);
    }

    protected String getResolvedName() {
        return this.resolvedName;
    }

    public String getType() {
        if (this.getName() == null) {
            return "<unknown>";
        }
        return FileTools.getExtension(new File(this.getName()));
    }

    public String getTypedName() {
        if (this.getName() == null) {
            return "<unknown>";
        }
        return new File(this.getName()).getName();
    }

    public Writer getWriter() throws IOException {
        throw new IOException("locator is read only");
    }

    public Writer getWriter(String string) throws IOException {
        throw new IOException("locator is read only");
    }

    public int hashCode() {
        return this.getResolvedName().hashCode();
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isOutOfSynch() {
        return false;
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isSynchSynchronous() {
        return false;
    }

    public ILocator[] listLocators(ILocatorNameFilter iLocatorNameFilter) throws IOException {
        return new ILocator[0];
    }

    private String resolveName(String string) {
        if (string == null) {
            return string;
        }
        if (!string.startsWith("/")) {
            Class<?> clazz = this.getClazz();
            while (clazz.isArray()) {
                clazz = clazz.getComponentType();
            }
            String string2 = clazz.getName();
            int n = string2.lastIndexOf(46);
            if (n != -1) {
                string = "/" + string2.substring(0, n).replace('.', '/') + "/" + string;
            }
        }
        return string;
    }

    protected void setEncoding(String string) {
        this.encoding = string;
    }

    public void synch() {
    }

    public String toString() {
        return this.getResolvedName();
    }

    public URL toURL() {
        return null;
    }
}

