/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.CommonLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;

public class TransientLocator
extends CommonLocator {
    private boolean alwaysUnchanged;
    private String canonicalName;
    private String localName;
    private String type;

    public TransientLocator(String string, String string2) {
        if (string == null || string2 == null) {
            throw new NullPointerException("name and type may not be null for TransientLocator");
        }
        this.localName = string;
        this.canonicalName = this.canonical(string);
        this.type = this.canonical(string2);
    }

    private String canonical(String string) {
        return string.trim().toLowerCase();
    }

    public boolean equals(Object object) {
        if (object instanceof TransientLocator) {
            TransientLocator transientLocator = (TransientLocator)object;
            return transientLocator.canonicalName.equals(this.canonicalName) && transientLocator.type.equals(this.type);
        }
        return false;
    }

    public boolean exists() {
        return false;
    }

    public ILocator getChild(String string) {
        return null;
    }

    public String getFullName() {
        return String.valueOf(this.localName) + "." + this.type;
    }

    public InputStream getInputStream() throws IOException {
        throw new FileNotFoundException("transient locator");
    }

    public String getLocalName() {
        return this.localName;
    }

    public OutputStream getOutputStream() throws IOException {
        throw new FileNotFoundException("transient locator");
    }

    public ILocator getParent() {
        return null;
    }

    public IRandomAccess getRandomAccess() throws IOException {
        throw new FileNotFoundException("transient locator");
    }

    public Reader getReader() throws IOException {
        throw new FileNotFoundException("transient locator");
    }

    public Reader getReader(String string) throws IOException {
        throw new FileNotFoundException("transient locator");
    }

    public String getType() {
        return this.type;
    }

    public String getTypedName() {
        return String.valueOf(this.localName) + "." + this.type;
    }

    public Writer getWriter() throws IOException {
        throw new FileNotFoundException("transient locator");
    }

    public Writer getWriter(String string) throws IOException {
        throw new FileNotFoundException("transient locator");
    }

    public int hashCode() {
        return this.canonicalName.hashCode();
    }

    public boolean isAlwaysUnchanged() {
        return this.alwaysUnchanged;
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isOutOfSynch() {
        return false;
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isSynchSynchronous() {
        return false;
    }

    public ILocator[] listLocators(ILocatorNameFilter iLocatorNameFilter) throws IOException {
        return new ILocator[0];
    }

    public void rename(String string) throws IOException {
        this.localName = FileTools.getBaseName(string);
        this.type = FileTools.getExtension(string);
    }

    public void setAlwaysUnchanged(boolean bl) {
        this.alwaysUnchanged = bl;
    }

    public void setLocalName(String string) {
        this.localName = string;
        this.canonicalName = this.canonical(string);
    }

    public void synch() {
    }

    public URL toURL() {
        return null;
    }

    public void delete() throws IOException {
    }
}

