/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging;

import de.intarsys.tools.format.TrivialDateFormat;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.Format;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class SimpleFormatter
extends Formatter {
    private static final String LF = System.getProperty("line.separator");
    private Format dateFormat = new TrivialDateFormat();
    private final StringBuffer sb = new StringBuffer();
    private boolean showDate = true;
    private boolean showLevel = true;
    private boolean showName = true;
    private boolean showThread = true;

    public synchronized String format(LogRecord logRecord) {
        int n;
        this.sb.setLength(0);
        if (this.isShowDate()) {
            this.sb.append("[");
            int n2 = this.sb.length();
            this.dateFormat.format(new Date(logRecord.getMillis()), this.sb, null);
            n = this.sb.length() - n2;
            while (n < 24) {
                this.sb.append(' ');
                ++n;
            }
            this.sb.append("]");
        }
        if (this.isShowLevel()) {
            this.sb.append("[");
            String string = logRecord.getLevel().toString();
            this.sb.append(string);
            n = string.length();
            while (n < 10) {
                this.sb.append(' ');
                ++n;
            }
            this.sb.append("]");
        }
        if (this.isShowName()) {
            String string = logRecord.getLoggerName();
            if (string == null) {
                string = "<unknown>";
            }
            this.sb.append("[");
            this.sb.append(string);
            this.sb.append("]");
        }
        if (this.isShowThread()) {
            this.sb.append("[");
            this.sb.append(Thread.currentThread().getName());
            this.sb.append("]");
        }
        this.sb.append(" ");
        this.sb.append(logRecord.getMessage());
        this.sb.append(LF);
        if (logRecord.getThrown() != null) {
            try {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                logRecord.getThrown().printStackTrace(printWriter);
                printWriter.close();
                this.sb.append(stringWriter.toString());
                this.sb.append(LF);
            }
            catch (Exception exception) {}
        }
        return this.sb.toString();
    }

    public boolean isShowDate() {
        return this.showDate;
    }

    public boolean isShowLevel() {
        return this.showLevel;
    }

    public boolean isShowName() {
        return this.showName;
    }

    public boolean isShowThread() {
        return this.showThread;
    }

    public void setShowDate(boolean bl) {
        this.showDate = bl;
    }

    public void setShowLevel(boolean bl) {
        this.showLevel = bl;
    }

    public void setShowName(boolean bl) {
        this.showName = bl;
    }

    public void setShowThread(boolean bl) {
        this.showThread = bl;
    }
}

