/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.message;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class MessageBundle {
    private ClassLoader classLoader;
    private String id;
    private Locale locale = Locale.getDefault();
    private String path;
    private ResourceBundle resourceBundle;

    protected static URL[] createURLs(String string) {
        if (string == null) {
            return new URL[0];
        }
        String[] stringArray = string.split(";");
        URL[] uRLArray = new URL[stringArray.length];
        try {
            int n = 0;
            while (n < uRLArray.length) {
                uRLArray[n] = new File(stringArray[n]).toURI().toURL();
                ++n;
            }
        }
        catch (MalformedURLException malformedURLException) {
            return new URL[0];
        }
        return uRLArray;
    }

    public MessageBundle() {
    }

    public MessageBundle(String string, ClassLoader classLoader) {
        this.path = string;
        this.classLoader = classLoader;
    }

    public MessageBundle(String string, String string2) {
        this.path = string;
        this.classLoader = new URLClassLoader(MessageBundle.createURLs(string2), Thread.currentThread().getContextClassLoader());
    }

    protected Object basicGetObject(String string) {
        try {
            ResourceBundle resourceBundle = this.getResourceBundle();
            if (resourceBundle != null) {
                return resourceBundle.getObject(string);
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public String basicGetString(String string) {
        try {
            ResourceBundle resourceBundle = this.getResourceBundle();
            if (resourceBundle != null) {
                return resourceBundle.getString(string);
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    protected ResourceBundle createResourceBundle() {
        if (this.getClassLoader() == null) {
            return ResourceBundle.getBundle(this.getPath(), this.getLocale());
        }
        return ResourceBundle.getBundle(this.getPath(), this.getLocale(), this.getClassLoader());
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected String getFallbackString(String string, Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        stringBuilder.append(string);
        stringBuilder.append("}");
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                stringBuilder.append("[");
                stringBuilder.append(objectArray[n]);
                stringBuilder.append("]");
                ++n;
            }
        }
        return stringBuilder.toString();
    }

    public String getId() {
        return this.id;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Object getObject(String string) {
        return this.basicGetObject(string);
    }

    public String getPath() {
        return this.path;
    }

    public ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            this.resourceBundle = this.createResourceBundle();
        }
        return this.resourceBundle;
    }

    public String getString(String string) {
        String string2 = this.basicGetString(string);
        if (string2 == null) {
            return this.getFallbackString(string, new String[0]);
        }
        return string2.replace("''", "'");
    }

    public String getString(String string, Object object) {
        String string2 = this.basicGetString(string);
        if (string2 == null) {
            return this.getFallbackString(string, new Object[]{object});
        }
        return MessageFormat.format(string2, object);
    }

    public String getString(String string, Object object, Object object2) {
        String string2 = this.basicGetString(string);
        if (string2 == null) {
            return this.getFallbackString(string, new Object[]{object, object2});
        }
        return MessageFormat.format(string2, object, object2);
    }

    public String getString(String string, Object object, Object object2, Object object3) {
        String string2 = this.basicGetString(string);
        if (string2 == null) {
            return this.getFallbackString(string, new Object[]{object, object2, object3});
        }
        return MessageFormat.format(string2, object, object2, object3);
    }

    public String getString(String string, Object object, Object object2, Object object3, Object object4) {
        String string2 = this.basicGetString(string);
        if (string2 == null) {
            return this.getFallbackString(string, new Object[]{object, object2, object3, object4});
        }
        return MessageFormat.format(string2, object, object2, object3, object4);
    }

    public String getString(String string, Object[] objectArray) {
        String string2 = this.basicGetString(string);
        if (string2 == null) {
            return this.getFallbackString(string, objectArray);
        }
        return MessageFormat.format(string2, objectArray);
    }

    public boolean lookupString(String string) {
        String string2 = this.basicGetString(string);
        return string2 != null;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setPath(String string) {
        this.path = string;
    }
}

