/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.number;

import de.intarsys.tools.number.NumberInstance;
import de.intarsys.tools.number.NumberInterval;
import de.intarsys.tools.number.NumberList;
import de.intarsys.tools.number.NumberWrapper;
import java.io.IOException;
import java.io.StringReader;

public class NumberParser {
    private StringReader r;

    public static NumberWrapper parse(String string) throws IOException {
        if (string == null) {
            return null;
        }
        return new NumberParser(string).parse();
    }

    protected NumberParser(String string) {
        this.r = new StringReader(string);
    }

    public int getChar() throws IOException {
        int n = this.r.read();
        return n;
    }

    private NumberWrapper makeWrapperObject(String string) {
        int n = string.indexOf(NumberInterval.SEPARATOR);
        if (n == -1) {
            double d = Double.parseDouble(string);
            NumberInstance numberInstance = new NumberInstance(d);
            return numberInstance;
        }
        if (n == 0) {
            throw new NumberFormatException("Missing parameter FROM in interval");
        }
        if (n == string.length() - 1) {
            throw new NumberFormatException("Missing parameter TO in interval");
        }
        NumberInterval numberInterval = new NumberInterval();
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        Double d = new Double(Double.parseDouble(string2));
        Double d2 = new Double(Double.parseDouble(string3));
        numberInterval.setFrom(d);
        numberInterval.setTo(d2);
        return numberInterval;
    }

    private NumberWrapper parse() throws IOException {
        NumberList numberList = new NumberList();
        numberList = this.parseNumberString(numberList);
        return numberList;
    }

    private NumberList parseNumberString(NumberList numberList) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = this.getChar();
        while (n > -1) {
            char c = (char)n;
            if (Character.isWhitespace(c)) {
                if (stringBuilder.length() != 0 && stringBuilder.charAt(stringBuilder.length() - 1) != '-') {
                    bl = true;
                }
            } else if (c == NumberList.SEPARATOR) {
                if (stringBuilder.length() != 0) {
                    numberList.add(this.makeWrapperObject(stringBuilder.toString()));
                    stringBuilder.setLength(0);
                    bl = false;
                }
            } else if (bl) {
                if (c != NumberInterval.SEPARATOR) {
                    throw new NumberFormatException("Space found in between number");
                }
                stringBuilder.append(c);
                bl = false;
            } else {
                stringBuilder.append(c);
            }
            n = this.getChar();
        }
        if (stringBuilder.length() > 0) {
            numberList.add(this.makeWrapperObject(stringBuilder.toString()));
        }
        return numberList;
    }
}

