/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.randomaccess;

import de.intarsys.tools.randomaccess.AbstractRandomAccess;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.IOException;

public class BufferedRandomAccess
extends AbstractRandomAccess {
    private static int DEFAULT_BUFFER_SIZE = 4096;
    private byte[] bytes;
    private long bytesOffset = 0L;
    private int count = 0;
    private int localOffset = 0;
    private IRandomAccess randomAccess;
    private long totalOffset = 0L;
    private boolean closed = false;
    private long length;
    private boolean bufferChanged = false;

    public BufferedRandomAccess(IRandomAccess iRandomAccess) throws IOException {
        this(iRandomAccess, DEFAULT_BUFFER_SIZE);
    }

    public BufferedRandomAccess(IRandomAccess iRandomAccess, int n) throws IOException {
        this.randomAccess = iRandomAccess;
        this.bytes = new byte[n];
        this.length = iRandomAccess.getLength();
    }

    protected int basicRead(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.localOffset >= this.count) {
            if (n2 >= this.bytes.length) {
                this.flushBuffer();
                this.randomAccess.seek(this.totalOffset);
                int n4 = this.randomAccess.read(byArray, n, n2);
                if (n4 > 0) {
                    this.totalOffset += (long)n4;
                    this.localOffset = this.count;
                }
                return n4;
            }
            this.fillBuffer();
            if (this.localOffset >= this.count) {
                return -1;
            }
        }
        int n5 = (n3 = this.count - this.localOffset) < n2 ? n3 : n2;
        System.arraycopy(this.bytes, this.localOffset, byArray, n, n5);
        this.localOffset += n5;
        this.totalOffset += (long)n5;
        return n5;
    }

    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        this.flushBuffer();
        this.randomAccess.close();
        this.setClosed(true);
    }

    public void flush() throws IOException {
        if (this.isClosed()) {
            throw new IOException("random access closed");
        }
        this.flushBuffer();
        this.randomAccess.flush();
    }

    protected void fillBuffer() throws IOException {
        this.flushBuffer();
        this.randomAccess.seek(this.totalOffset);
        this.count = this.randomAccess.read(this.bytes, 0, this.bytes.length);
    }

    protected void flushBuffer() throws IOException {
        if (this.bufferChanged && this.count > 0) {
            this.randomAccess.seek(this.bytesOffset);
            this.randomAccess.write(this.bytes, 0, this.count);
        }
        this.bytesOffset = this.totalOffset;
        this.localOffset = 0;
        this.count = 0;
        this.bufferChanged = false;
    }

    public long getLength() throws IOException {
        if (this.isClosed()) {
            throw new IOException("random access closed");
        }
        return this.length;
    }

    public long getOffset() throws IOException {
        if (this.isClosed()) {
            throw new IOException("random access closed");
        }
        return this.totalOffset;
    }

    public boolean isReadOnly() {
        return this.randomAccess.isReadOnly();
    }

    public int read() throws IOException {
        if (this.isClosed()) {
            throw new IOException("random access closed");
        }
        if (this.localOffset >= this.count) {
            this.fillBuffer();
            if (this.localOffset >= this.count) {
                return -1;
            }
        }
        ++this.totalOffset;
        return this.bytes[this.localOffset++] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        if (this.isClosed()) {
            throw new IOException("random access closed");
        }
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.isClosed()) {
            throw new IOException("random access closed");
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.basicRead(byArray, n + n3, n2 - n3);
            if (n4 <= 0) break;
            n3 += n4;
        }
        if (n3 == 0) {
            return -1;
        }
        return n3;
    }

    public void seek(long l) throws IOException {
        if (this.isClosed()) {
            throw new IOException("random access closed");
        }
        this.totalOffset = l;
        long l2 = this.totalOffset - this.bytesOffset;
        if (l2 < 0L || l2 >= (long)this.count) {
            this.flushBuffer();
        } else {
            this.localOffset = (int)l2;
        }
    }

    public void seekBy(long l) throws IOException {
        if (this.isClosed()) {
            throw new IOException("random access closed");
        }
        this.totalOffset += l;
        long l2 = (long)this.localOffset + l;
        if (l2 < 0L || l2 >= (long)this.count) {
            this.flushBuffer();
        } else {
            this.localOffset = (int)l2;
        }
    }

    public void setLength(long l) throws IOException {
        if (this.isClosed()) {
            throw new IOException("random access closed");
        }
        if (l < this.bytesOffset + (long)this.bytes.length) {
            this.flushBuffer();
        }
        if (l < this.totalOffset) {
            this.totalOffset = l;
            this.bytesOffset = l;
        }
        this.length = l;
        this.randomAccess.setLength(l);
    }

    public void write(byte[] byArray) throws IOException {
        if (this.isClosed()) {
            throw new IOException("random access closed");
        }
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.isClosed()) {
            throw new IOException("random access closed");
        }
        if (n2 >= this.bytes.length) {
            this.flushBuffer();
            this.randomAccess.seek(this.totalOffset);
            this.randomAccess.write(byArray, n, n2);
            this.totalOffset += (long)n2;
            this.bytesOffset = this.totalOffset;
            if (this.totalOffset > this.length) {
                this.length = this.totalOffset;
            }
            return;
        }
        if (n2 > this.bytes.length - this.localOffset) {
            this.flushBuffer();
        }
        System.arraycopy(byArray, n, this.bytes, this.localOffset, n2);
        this.bufferChanged = true;
        this.totalOffset += (long)n2;
        this.localOffset += n2;
        if (this.totalOffset > this.length) {
            this.length = this.totalOffset;
        }
        if (this.localOffset >= this.count) {
            this.count = this.localOffset;
        }
    }

    public void write(int n) throws IOException {
        if (this.isClosed()) {
            throw new IOException("random access closed");
        }
        if (this.localOffset >= this.bytes.length) {
            this.flushBuffer();
        }
        this.bufferChanged = true;
        if (this.localOffset == this.count) {
            ++this.count;
        }
        ++this.totalOffset;
        if (this.totalOffset > this.length) {
            this.length = this.totalOffset;
        }
        this.bytes[this.localOffset++] = (byte)n;
    }

    protected boolean isClosed() {
        return this.closed;
    }

    protected void setClosed(boolean bl) {
        this.closed = bl;
    }
}

