/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reflect;

import de.intarsys.tools.reflect.ClassTools;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectTools {
    private static final Class[] EMPTY_PARAMETERTYPES = new Class[0];
    private static final Object[] EMPTY_PARAMETERS = new Object[0];
    public static final String GET_PREFIX = "get";
    public static final String IS_PREFIX = "is";

    protected static Object basicGet(Object object, String string) throws NoSuchFieldException, IllegalAccessException, InvocationTargetException {
        try {
            Method method = ObjectTools.findGetter(object, string);
            return method.invoke(object, null);
        }
        catch (Exception exception) {
            try {
                Field field = object.getClass().getField(string);
                return field.get(object);
            }
            catch (Exception exception2) {
                try {
                    Method method = object.getClass().getMethod(string, null);
                    return method.invoke(object, null);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new NoSuchFieldException("field '" + string + "' not found in '" + object + "'");
                }
            }
        }
    }

    protected static Object basicInsert(Object object, String string, Object object2) throws NoSuchFieldException, IllegalAccessException, IllegalAccessError {
        try {
            Method method = ObjectTools.findInserter(object, string, object2);
            return method.invoke(object, object2);
        }
        catch (Exception exception) {
            Field field = object.getClass().getField(string);
            Object object3 = field.get(object);
            if (object3 instanceof Collection) {
                if (((Collection)object3).add(object2)) {
                    return object2;
                }
                return null;
            }
            throw new IllegalAccessError("can't insert in " + string);
        }
    }

    protected static Object basicInvoke(Object object, String string, Object ... objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = ObjectTools.findMethod(object, string, objectArray);
        return method.invoke(object, objectArray);
    }

    protected static Object basicRemove(Object object, String string, Object object2) throws NoSuchFieldException, IllegalAccessException, IllegalAccessError {
        try {
            Method method = ObjectTools.findRemover(object, string, object2);
            return method.invoke(object, object2);
        }
        catch (Exception exception) {
            Field field = object.getClass().getField(string);
            Object object3 = field.get(object);
            if (object3 instanceof Collection) {
                if (((Collection)object3).remove(object2)) {
                    return object2;
                }
                return null;
            }
            throw new IllegalAccessError("can't remove from " + string);
        }
    }

    protected static Object basicSet(Object object, String string, Object object2) throws NoSuchFieldException, IllegalAccessException {
        try {
            Method method = ObjectTools.findSetter(object, string, object2);
            return method.invoke(object, object2);
        }
        catch (Exception exception) {
            Field field = object.getClass().getField(string);
            Object object3 = field.get(object);
            field.set(object, object2);
            return object3;
        }
    }

    protected static boolean checkCandidate(Method method, String string, Class[] classArray) {
        if (!method.getName().equals(string)) {
            return false;
        }
        Class[] classArray2 = method.getParameterTypes();
        return ObjectTools.checkCandidateClasses(classArray2, classArray);
    }

    protected static boolean checkCandidateClass(Class clazz, Class clazz2) {
        return clazz.isAssignableFrom(clazz2);
    }

    protected static boolean checkCandidateClasses(Class[] classArray, Class[] classArray2) {
        if (classArray.length != classArray2.length) {
            return false;
        }
        int n = 0;
        while (n < classArray.length) {
            if (!ObjectTools.checkCandidateClass(classArray[n], classArray2[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static <T> T createObject(Class clazz, Class<T> clazz2) throws ObjectCreationException {
        return ObjectTools.createObject(clazz, clazz2, EMPTY_PARAMETERTYPES, EMPTY_PARAMETERS);
    }

    public static <T> T createObject(Class clazz, Class<T> clazz2, Class[] classArray, Object[] objectArray) throws ObjectCreationException {
        if (clazz == null) {
            throw new ObjectCreationException("class missing");
        }
        try {
            if (clazz2 != null && !clazz2.isAssignableFrom(clazz)) {
                throw new ObjectCreationException("class '" + clazz.getName() + "' not compatible with expected type '" + clazz2 + "'");
            }
            if (objectArray == EMPTY_PARAMETERS) {
                return clazz.newInstance();
            }
            Constructor constructor = clazz.getConstructor(classArray);
            return constructor.newInstance(objectArray);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new ObjectCreationException("class '" + clazz.getName() + "' can not be instantiated", noClassDefFoundError);
        }
        catch (InstantiationException instantiationException) {
            throw new ObjectCreationException("class '" + clazz.getName() + "' can not be instantiated", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ObjectCreationException("class '" + clazz.getName() + "' can not be instantiated", illegalAccessException);
        }
        catch (SecurityException securityException) {
            throw new ObjectCreationException("class '" + clazz.getName() + "' can not be instantiated", securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ObjectCreationException("class '" + clazz.getName() + "' can not be instantiated", noSuchMethodException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ObjectCreationException("class '" + clazz.getName() + "' can not be instantiated", illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ObjectCreationException("class '" + clazz.getName() + "' can not be instantiated", invocationTargetException);
        }
    }

    public static <T> T createObject(String string, Class<T> clazz, ClassLoader classLoader) throws ObjectCreationException {
        Class<T> clazz2 = ClassTools.createClass(string, clazz, classLoader);
        return ObjectTools.createObject(clazz2, clazz);
    }

    public static Method findGetter(Object object, String string) throws SecurityException, NoSuchMethodException {
        try {
            String string2 = GET_PREFIX + Character.toUpperCase(string.charAt(0)) + string.substring(1);
            return object.getClass().getMethod(string2, null);
        }
        catch (RuntimeException runtimeException) {
            String string3 = IS_PREFIX + Character.toUpperCase(string.charAt(0)) + string.substring(1);
            return object.getClass().getMethod(string3, null);
        }
    }

    public static Method findInserter(Object object, String string, Object object2) throws SecurityException, NoSuchMethodException {
        String string2 = "insert" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
        return ObjectTools.findMethod(object, string2, object2);
    }

    protected static Method findMatchingMethod(Class clazz, String string, Class[] classArray) throws SecurityException, NoSuchMethodException {
        Method[] methodArray = clazz.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            Method method = methodArray[n];
            if (ObjectTools.checkCandidate(method, string, classArray)) {
                return method;
            }
            ++n;
        }
        Method method = clazz.getMethod(string, classArray);
        return method;
    }

    public static Method findMethod(Object object, String string, Object ... objectArray) throws SecurityException, NoSuchMethodException {
        Class<?> clazz = object.getClass();
        Class[] classArray = new Class[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            classArray[n] = objectArray[n].getClass();
            ++n;
        }
        Method method = null;
        try {
            method = ObjectTools.findSimpleMethod(clazz, string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = ObjectTools.findMatchingMethod(clazz, string, classArray);
        }
        return method;
    }

    public static Method findRemover(Object object, String string, Object object2) throws SecurityException, NoSuchMethodException {
        String string2 = "remove" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
        return ObjectTools.findMethod(object, string2, object2);
    }

    public static Method findSetter(Object object, String string, Object object2) throws SecurityException, NoSuchMethodException {
        String string2 = "set" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
        return ObjectTools.findMethod(object, string2, object2);
    }

    protected static Method findSimpleMethod(Class clazz, String string, Class ... classArray) throws SecurityException, NoSuchMethodException {
        Method method = clazz.getMethod(string, classArray);
        return method;
    }

    public static Object get(Object object, String string) throws IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        int n;
        String string2 = string.replace('[', '.');
        if (string2 != string) {
            string2 = string2.replace(']', ' ');
        }
        if ((n = string2.indexOf(46)) == -1) {
            return ObjectTools.basicGet(object, string);
        }
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1);
        Object object2 = ObjectTools.basicGet(object, string3);
        return ObjectTools.get(object2, string4);
    }

    public static Object insert(Object object, String string, Object object2) throws IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        int n;
        String string2 = string.replace('[', '.');
        if (string2 != string) {
            string2 = string2.replace(']', ' ');
        }
        if ((n = string2.indexOf(46)) == -1) {
            return ObjectTools.basicInsert(object, string, object2);
        }
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1);
        Object object3 = ObjectTools.basicGet(object, string3);
        return ObjectTools.insert(object3, string4, object2);
    }

    public static Object invoke(Object object, String string, Object ... objectArray) throws IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException, NoSuchFieldException {
        int n;
        String string2 = string.replace('[', '.');
        if (string2 != string) {
            string2 = string2.replace(']', ' ');
        }
        if ((n = string2.indexOf(46)) == -1) {
            return ObjectTools.basicInvoke(object, string, objectArray);
        }
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1);
        Object object2 = ObjectTools.basicGet(object, string3);
        return ObjectTools.invoke(object2, string4, objectArray);
    }

    public static Object remove(Object object, String string, Object object2) throws IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        int n;
        String string2 = string.replace('[', '.');
        if (string2 != string) {
            string2 = string2.replace(']', ' ');
        }
        if ((n = string2.indexOf(46)) == -1) {
            return ObjectTools.basicRemove(object, string, object2);
        }
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1);
        Object object3 = ObjectTools.basicGet(object, string3);
        return ObjectTools.remove(object3, string4, object2);
    }

    public static Object set(Object object, String string, Object object2) throws IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        int n;
        String string2 = string.replace('[', '.');
        if (string2 != string) {
            string2 = string2.replace(']', ' ');
        }
        if ((n = string2.indexOf(46)) == -1) {
            return ObjectTools.basicSet(object, string, object2);
        }
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1);
        Object object3 = ObjectTools.basicGet(object, string3);
        return ObjectTools.set(object3, string4, object2);
    }
}

