/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.resourcetracker;

import de.intarsys.tools.resourcetracker.IResourceReference;
import de.intarsys.tools.resourcetracker.PhantomResourceReference;
import de.intarsys.tools.resourcetracker.ResourceFinalizer;
import de.intarsys.tools.resourcetracker.SoftResourceReference;
import de.intarsys.tools.resourcetracker.WeakResourceReference;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;

public abstract class ResourceTracker {
    private IResourceReference[] references = new IResourceReference[1000];
    private int next = 0;
    private ResourceFinalizer finalizer = null;

    public ResourceTracker() {
    }

    public ResourceTracker(ResourceFinalizer resourceFinalizer) {
        this.finalizer = resourceFinalizer;
    }

    protected synchronized void add(IResourceReference iResourceReference) {
        if (this.next >= this.references.length) {
            PhantomResourceReference[] phantomResourceReferenceArray = new PhantomResourceReference[this.references.length + 1000];
            System.arraycopy(this.references, 0, phantomResourceReferenceArray, 0, this.references.length);
            this.references = phantomResourceReferenceArray;
        }
        this.references[this.next++] = iResourceReference;
    }

    protected abstract void basicDispose(Object var1);

    protected void dispose(IResourceReference iResourceReference) {
        this.remove(iResourceReference);
        if (iResourceReference.getResource() != null) {
            this.basicDispose(iResourceReference.getResource());
        }
    }

    protected ReferenceQueue getQueue() {
        return this.finalizer.getQueue();
    }

    protected synchronized void remove(IResourceReference iResourceReference) {
        int n = this.next;
        int n2 = 0;
        while (n2 < n) {
            if (this.references[n2] == iResourceReference) {
                --this.next;
                System.arraycopy(this.references, n2 + 1, this.references, n2, this.next - n2);
                this.references[this.next] = null;
            }
            ++n2;
        }
    }

    public PhantomReference trackPhantom(Object object, Object object2) {
        if (this.finalizer == null) {
            this.finalizer = ResourceFinalizer.get();
        }
        PhantomResourceReference phantomResourceReference = new PhantomResourceReference(object, object2, this);
        this.add(phantomResourceReference);
        return phantomResourceReference;
    }

    public SoftReference trackSoft(Object object, Object object2) {
        if (this.finalizer == null) {
            this.finalizer = ResourceFinalizer.get();
        }
        SoftResourceReference softResourceReference = new SoftResourceReference(object, object2, this);
        this.add(softResourceReference);
        return softResourceReference;
    }

    public WeakReference trackWeak(Object object, Object object2) {
        if (this.finalizer == null) {
            this.finalizer = ResourceFinalizer.get();
        }
        WeakResourceReference weakResourceReference = new WeakResourceReference(object, object2, this);
        this.add(weakResourceReference);
        return weakResourceReference;
    }
}

