/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.stream;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class HexDumpStream
extends FilterOutputStream {
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static int BYTES_PER_LINE = 16;
    private int tbc = 0;
    private int lbc = 0;
    private char[] line = new char[BYTES_PER_LINE];

    public HexDumpStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void flush() throws IOException {
        String string = Long.toHexString(this.tbc);
        int n = string.length();
        while (n < 8) {
            this.out.write(48);
            ++n;
        }
        this.out.write(string.getBytes());
        this.out.write(32);
        n = 0;
        while (n < this.lbc) {
            this.out.write(hex[this.line[n] >> 4 & 0xF]);
            this.out.write(hex[this.line[n] >> 0 & 0xF]);
            this.out.write(32);
            ++n;
        }
        while (n < BYTES_PER_LINE) {
            this.out.write(32);
            this.out.write(32);
            this.out.write(32);
            ++n;
        }
        this.out.write(32);
        n = 0;
        while (n < this.lbc) {
            if (Character.isISOControl(this.line[n])) {
                this.out.write(46);
            } else {
                this.out.write(this.line[n]);
            }
            ++n;
        }
        this.out.write(System.getProperty("line.separator").getBytes());
        this.tbc += this.lbc;
        this.lbc = 0;
        super.flush();
    }

    public synchronized void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            this.write(byArray[n + n3]);
            ++n3;
        }
    }

    public synchronized void write(int n) throws IOException {
        this.line[this.lbc++] = (char)n;
        if (this.lbc >= BYTES_PER_LINE) {
            this.flush();
        }
    }
}

