/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.stream;

import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;

public class StreamTools {
    public static final int MAX_BUFFER = 100000;

    public static void close(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static void close(IRandomAccess iRandomAccess) {
        try {
            if (iRandomAccess != null) {
                iRandomAccess.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static void close(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static void close(RandomAccessFile randomAccessFile) {
        try {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static void close(Reader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static void close(Writer writer) {
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static void copyEncoded(Reader reader, Writer writer) throws IOException {
        try {
            char[] cArray = new char[100000];
            int n = reader.read(cArray);
            while (n != -1) {
                writer.write(cArray, 0, n);
                n = reader.read(cArray);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException("copying failed (" + exception.getMessage() + ")");
        }
    }

    public static void copyEncodedStream(InputStream inputStream, String string, OutputStream outputStream, String string2) throws IOException {
        if (string == null | string2 == null | string.equals(string2)) {
            StreamTools.copyStream(inputStream, false, outputStream, false);
        }
        InputStreamReader inputStreamReader = null;
        OutputStreamWriter outputStreamWriter = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, string);
            outputStreamWriter = new OutputStreamWriter(outputStream, string2);
            char[] cArray = new char[100000];
            int n = inputStreamReader.read(cArray);
            while (n != -1) {
                outputStreamWriter.write(cArray, 0, n);
                n = inputStreamReader.read(cArray);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException("copying failed (" + exception.getMessage() + ")");
        }
    }

    public static void copyStream(InputStream inputStream, boolean bl, OutputStream outputStream, boolean bl2) throws IOException {
        try {
            try {
                byte[] byArray = new byte[100000];
                int n = inputStream.read(byArray);
                while (n != -1) {
                    outputStream.write(byArray, 0, n);
                    n = inputStream.read(byArray);
                }
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw ExceptionTools.createIOException("copying failed (" + exception.getMessage() + ")", exception);
            }
        }
        finally {
            if (bl) {
                StreamTools.close(inputStream);
            }
            if (bl2) {
                StreamTools.close(outputStream);
            }
        }
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        StreamTools.copyStream(inputStream, true, outputStream, true);
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        try {
            long l2 = l;
            byte[] byArray = new byte[(int)l];
            while (l2 > 0L) {
                int n = inputStream.read(byArray, 0, (int)l2);
                if (n != -1) {
                    outputStream.write(byArray, 0, n);
                    l2 -= (long)n;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException("copying failed (" + exception.getMessage() + ")");
        }
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamTools.copyStream(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static String toString(InputStream inputStream, String string) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamTools.copyStream(inputStream, byteArrayOutputStream);
        if (string == null) {
            string = System.getProperty("file.encoding");
        }
        return byteArrayOutputStream.toString(string);
    }

    public static String toString(Reader reader) throws IOException {
        StringWriter stringWriter = new StringWriter();
        StreamTools.copyEncoded(reader, stringWriter);
        return stringWriter.toString();
    }

    private StreamTools() {
    }
}

