/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.string;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.string.ConverterException;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class Converter {
    public static final String ELEMENT_SEPARATOR = ";";
    public static final String KEY_VALUE_SEPARATOR = "=";

    public static boolean asBoolean(String string) throws ConverterException {
        if ((string = string.toLowerCase().trim()).equals("false") || string.equals("f") || string.equals("no") || string.equals("n") || string.equals("0") || string.equals("falsch") || string.equals("nein")) {
            return false;
        }
        if (string.equals("true") || string.equals("t") || string.equals("yes") || string.equals("y") || string.equals("1") || string.equals("wahr") || string.equals("w") || string.equals("ja") || string.equals("j")) {
            return true;
        }
        throw new ConverterException("Can't parse boolean string: " + string + " to a legal value");
    }

    public static boolean asBoolean(String string, boolean bl) {
        if (StringTools.isEmpty(string)) {
            return bl;
        }
        try {
            return Converter.asBoolean(string);
        }
        catch (ConverterException converterException) {
            return bl;
        }
    }

    public static boolean asBooleanChecked(String string, boolean bl) throws ConverterException {
        if (StringTools.isEmpty(string)) {
            return bl;
        }
        return Converter.asBoolean(string);
    }

    public static Class asClass(String string) throws ConverterException {
        if ((string = string.trim()).equals("")) {
            return null;
        }
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConverterException(String.valueOf(string) + " is not a possible Classname!");
        }
    }

    public static File asFile(String string) throws ConverterException {
        String string2 = string.trim();
        if ((string2 = FileTools.trimPath(string2)).equals("")) {
            throw new ConverterException("Parameter " + string + " is not a valid Filename");
        }
        try {
            return new File(string2);
        }
        catch (NullPointerException nullPointerException) {
            throw new ConverterException("Can't parse file string: " + string2 + " to a file");
        }
    }

    public static double asFloat(String string) throws ConverterException {
        try {
            string = string.trim();
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConverterException("Can't parse number string: " + string + " to a legal value");
        }
    }

    public static float[] asFloatArray(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ELEMENT_SEPARATOR, false);
        float[] fArray = new float[stringTokenizer.countTokens()];
        int n = 0;
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                fArray[n] = Float.parseFloat(string2.trim());
                ++n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return fArray;
    }

    public static int[] asIntArray(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ELEMENT_SEPARATOR, false);
        int[] nArray = new int[stringTokenizer.countTokens()];
        int n = 0;
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                nArray[n] = Integer.parseInt(string2.trim());
                ++n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return nArray;
    }

    public static int asInteger(String string) throws ConverterException {
        try {
            string = string.trim();
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConverterException("Can't parse integer string: " + string + " to a legal value");
        }
    }

    public static int asInteger(String string, int n) {
        if (StringTools.isEmpty(string)) {
            return n;
        }
        try {
            return Converter.asInteger(string);
        }
        catch (ConverterException converterException) {
            return n;
        }
    }

    public static int asIntegerChecked(String string, int n) throws ConverterException {
        if (StringTools.isEmpty(string)) {
            return n;
        }
        return Converter.asInteger(string);
    }

    public static Map asMap(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>(5);
        if (string == null) {
            return hashMap;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ELEMENT_SEPARATOR, false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3;
            String string4 = stringTokenizer.nextToken();
            int n = string4.indexOf(KEY_VALUE_SEPARATOR);
            if (n == -1) {
                string3 = string4;
                string2 = "";
            } else {
                string3 = string4.substring(0, n);
                if (n >= string4.length()) {
                    string2 = "";
                }
                string2 = string4.substring(n + 1);
            }
            hashMap.put(string3, string2);
        }
        return hashMap;
    }

    public static Map asMapBoolean(String string) {
        Map map = Converter.asMap(string);
        HashMap hashMap = new HashMap(map.size() * 2);
        for (Map.Entry entry : map.entrySet()) {
            Boolean bl = Boolean.valueOf((String)entry.getValue());
            hashMap.put(entry.getKey(), bl);
        }
        return hashMap;
    }

    public static String asString(String string, String string2) {
        if (StringTools.isEmpty(string)) {
            return string2;
        }
        return string.trim();
    }

    public static String[] asStringArray(String string) {
        if (string == null) {
            return null;
        }
        return string.split(ELEMENT_SEPARATOR);
    }

    private Converter() {
    }
}

