/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.awt.environment;

import de.intarsys.cwt.awt.environment.CwtAwtGraphicsEnvironment;
import de.intarsys.cwt.common.BlendMode;
import de.intarsys.cwt.common.IPaint;
import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.cwt.environment.IGraphicsEnvironment;
import de.intarsys.cwt.image.IImage;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.util.Map;

public class CwtAwtGraphicsContext
implements IGraphicsContext {
    private Graphics2D graphics;
    private Paint savedBackground;
    private BlendMode blendMode = (BlendMode)BlendMode.META.getDefault();

    public CwtAwtGraphicsContext(Graphics2D graphics2D) {
        this.graphics = graphics2D;
    }

    public void clip(Shape shape) {
        if (shape == null) {
            return;
        }
        if (shape.getPathIterator(null).isDone()) {
            return;
        }
        this.graphics.clip(shape);
    }

    public void dispose() {
        this.graphics.dispose();
    }

    public void disposeClip(Object object) {
    }

    public void draw(Shape shape) {
        this.graphics.draw(shape);
    }

    public void drawImage(IImage iImage, float f, float f2) {
        iImage.drawFromGraphicsContext(this, f, f2);
    }

    public void drawString(String string, float f, float f2) {
        this.graphics.drawString(string, f, f2);
    }

    public void fill(Shape shape) {
        Paint paint = this.graphics.getPaint();
        this.graphics.setPaint(this.savedBackground);
        try {
            this.graphics.fill(shape);
        }
        finally {
            this.graphics.setPaint(paint);
        }
    }

    public Color getBackgroundColor() {
        return this.graphics.getBackground();
    }

    public BlendMode getBlendMode() {
        return this.blendMode;
    }

    public Shape getClip() {
        return this.graphics.getClip();
    }

    public Font getFont() {
        return this.graphics.getFont();
    }

    public FontRenderContext getFontRenderContext() {
        return this.graphics.getFontRenderContext();
    }

    public Color getForegroundColor() {
        return this.graphics.getColor();
    }

    public Graphics2D getGraphics() {
        return this.graphics;
    }

    public IGraphicsEnvironment getGraphicsEnvironment() {
        return CwtAwtGraphicsEnvironment.get();
    }

    public RenderingHints getRenderingHints() {
        return this.graphics.getRenderingHints();
    }

    public AffineTransform getTransform() {
        return this.graphics.getTransform();
    }

    public void resetAdvanced() {
    }

    public void rotate(float f) {
        this.graphics.rotate(f);
    }

    public void scale(float f, float f2) {
        this.graphics.scale(f, f2);
    }

    public void setBackgroundColor(Color color) {
        this.graphics.setBackground(color);
        this.savedBackground = color;
    }

    public void setBackgroundPaint(IPaint iPaint) {
        iPaint.setBackgroundPaintFromGraphicsContext(this);
    }

    public void setBackgroundPaint(Paint paint) {
        this.savedBackground = paint;
    }

    public void setBlendMode(BlendMode blendMode) {
        this.blendMode = blendMode;
    }

    public void setClip(Shape shape) {
        if (shape == null) {
            this.graphics.setClip(null);
            return;
        }
        if (shape.getPathIterator(null).isDone()) {
            this.graphics.setClip(0, 0, 0, 0);
            return;
        }
        this.graphics.setClip(shape);
    }

    public void setFont(Font font) {
        this.graphics.setFont(font);
    }

    public void setForegroundColor(Color color) {
        this.graphics.setColor(color);
    }

    public void setForegroundPaint(IPaint iPaint) {
        iPaint.setForegroundPaintFromGraphicsContext(this);
    }

    public void setForegroundPaint(Paint paint) {
        this.graphics.setPaint(paint);
    }

    public void setPaintMode() {
        this.graphics.setPaintMode();
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this.graphics.setRenderingHint(key, object);
    }

    public void setRenderingHints(Map map) {
        this.graphics.setRenderingHints(map);
    }

    public void setStroke(Stroke stroke) {
        this.graphics.setStroke(stroke);
    }

    public void setTransform(AffineTransform affineTransform) {
        this.graphics.setTransform(affineTransform);
    }

    public void setXORMode(Color color) {
        this.graphics.setXORMode(color);
    }

    public Point textExtent(String string) {
        this.getFont().getStringBounds(string, this.getFontRenderContext());
        return new Point(0, 0);
    }

    public void transform(AffineTransform affineTransform) {
        this.graphics.transform(affineTransform);
    }

    public void translate(float f, float f2) {
        this.graphics.translate(f, f2);
    }
}

